/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import techreborn.api.RollingMachineRecipe;
import techreborn.client.gui.GuiRollingMachine;

public class ShapelessRollingMachineHandler
extends ShapelessRecipeHandler {
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiRollingMachine.class;
    }

    public String getRecipeName() {
        return "Shapeless Rolling Machine";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "rollingcraftingnoshape", new Object[0]));
    }

    public String getOverlayIdentifier() {
        return "rollingcraftingnoshape";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("rollingcraftingnoshape") && ((Object)((Object)this)).getClass() == ShapelessRollingMachineHandler.class) {
            List<IRecipe> allrecipes = RollingMachineRecipe.instance.getRecipeList();
            for (IRecipe irecipe : allrecipes) {
                ShapelessRecipeHandler.CachedShapelessRecipe recipe = null;
                if (irecipe instanceof ShapelessRecipes) {
                    recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
                } else if (irecipe instanceof ShapelessOreRecipe) {
                    recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
                }
                if (recipe == null) continue;
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<IRecipe> allrecipes = RollingMachineRecipe.instance.getRecipeList();
        for (IRecipe irecipe : allrecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            ShapelessRecipeHandler.CachedShapelessRecipe recipe = null;
            if (irecipe instanceof ShapelessRecipes) {
                recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
            } else if (irecipe instanceof ShapelessOreRecipe) {
                recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
            }
            if (recipe == null) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<IRecipe> allrecipes = RollingMachineRecipe.instance.getRecipeList();
        for (IRecipe irecipe : allrecipes) {
            ShapelessRecipeHandler.CachedShapelessRecipe recipe = null;
            if (irecipe instanceof ShapelessRecipes) {
                recipe = this.shapelessRecipe((ShapelessRecipes)irecipe);
            } else if (irecipe instanceof ShapelessOreRecipe) {
                recipe = this.forgeShapelessRecipe((ShapelessOreRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains((Collection)recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation((Collection)recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    private ShapelessRecipeHandler.CachedShapelessRecipe shapelessRecipe(ShapelessRecipes recipe) {
        if (recipe.field_77579_b == null) {
            return null;
        }
        return new ShapelessRecipeHandler.CachedShapelessRecipe((ShapelessRecipeHandler)this, recipe.field_77579_b, recipe.func_77571_b());
    }

    public String getGuiTexture() {
        return "techreborn:textures/gui/rolling_machine.png";
    }
}

