/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.nei.recipes;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import reborncore.common.util.ItemUtils;
import techreborn.api.recipe.IBaseRecipeType;
import techreborn.api.recipe.RecipeHandler;
import techreborn.compat.nei.recipes.INeiBaseRecipe;

public abstract class GenericRecipeHander
extends TemplateRecipeHandler {
    public INeiBaseRecipe getNeiBaseRecipe() {
        return null;
    }

    public String getRecipeName() {
        return RecipeHandler.getUserFreindlyName(this.getNeiBaseRecipe().getRecipeName());
    }

    public String getGuiTexture() {
        return this.getNeiBaseRecipe().getGuiTexture();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return this.getNeiBaseRecipe().getGuiClass();
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)4, (int)4, (int)166, (int)78);
        GuiDraw.drawTooltipBox((int)10, (int)80, (int)145, (int)50);
        GuiDraw.drawString((String)"Info:", (int)14, (int)84, (int)-1);
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (recipe instanceof CachedGenericRecipe) {
            CachedGenericRecipe genericRecipe = (CachedGenericRecipe)recipe;
            float scale = 0.9f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
            symbols.setGroupingSeparator('.');
            formatter.setDecimalFormatSymbols(symbols);
            GuiDraw.drawString((String)("EU needed: " + formatter.format(new Integer(genericRecipe.recipie.euPerTick() * genericRecipe.recipie.tickTime()).longValue())), (int)16, (int)105, (int)-1);
            GuiDraw.drawString((String)("Ticks to process: " + genericRecipe.recipie.tickTime()), (int)14, (int)115, (int)-1);
            GuiDraw.drawString((String)("Time to process: " + genericRecipe.recipie.tickTime() / 20 + " seconds"), (int)14, (int)125, (int)-1);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getNeiBaseRecipe().getRecipeName())) {
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName(this.getNeiBaseRecipe().getRecipeName())) {
                this.addCached(recipeType);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName(this.getNeiBaseRecipe().getRecipeName())) {
            for (int i = 0; i < recipeType.getOutputsSize(); ++i) {
                if (!ItemUtils.isItemEqual((ItemStack)recipeType.getOutput(i), (ItemStack)result, (boolean)true, (boolean)false, (boolean)true)) continue;
                this.addCached(recipeType);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName(this.getNeiBaseRecipe().getRecipeName())) {
            for (ItemStack input : recipeType.getInputs()) {
                if (!ItemUtils.isItemEqual((ItemStack)ingredient, (ItemStack)input, (boolean)true, (boolean)false, (boolean)true)) continue;
                this.addCached(recipeType);
            }
        }
    }

    private void addCached(IBaseRecipeType recipie) {
        this.arecipes.add(new CachedGenericRecipe(recipie, this.getNeiBaseRecipe()));
    }

    public class CachedGenericRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private List<PositionedStack> input;
        private List<PositionedStack> outputs;
        public Point focus;
        public IBaseRecipeType recipie;
        public INeiBaseRecipe neiBaseRecipe;

        public CachedGenericRecipe(IBaseRecipeType recipe, INeiBaseRecipe neiBaseRecipe) {
            super((TemplateRecipeHandler)GenericRecipeHander.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.recipie = recipe;
            this.neiBaseRecipe = neiBaseRecipe;
            neiBaseRecipe.addPositionedStacks(this.input, this.outputs, recipe);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(GenericRecipeHander.this.cycleticks / 20, this.input);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

