/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.nei.recipes;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import reborncore.client.gui.GuiUtil;
import techreborn.api.recipe.IBaseRecipeType;
import techreborn.api.recipe.machines.IndustrialSawmillRecipe;
import techreborn.client.gui.GuiIndustrialSawmill;
import techreborn.compat.nei.recipes.GenericRecipeHander;
import techreborn.compat.nei.recipes.INeiBaseRecipe;
import techreborn.lib.Reference;

public class IndustrialSawmillRecipeHandler
extends GenericRecipeHander
implements INeiBaseRecipe {
    @Override
    public void addPositionedStacks(List<PositionedStack> input, List<PositionedStack> outputs, IBaseRecipeType recipeType) {
        int offset = 4;
        if (recipeType.getInputs().size() > 0) {
            PositionedStack pStack = new PositionedStack((Object)recipeType.getInputs().get(0), 32 - offset, 26 - offset, false);
            input.add(pStack);
        }
        if (recipeType.getInputs().size() > 1) {
            PositionedStack pStack2 = new PositionedStack((Object)recipeType.getInputs().get(1), 32 - offset, 44 - offset, false);
            input.add(pStack2);
        }
        if (recipeType.getOutputsSize() > 0) {
            PositionedStack pStack3 = new PositionedStack((Object)recipeType.getOutput(0), 84 - offset, 35 - offset, false);
            outputs.add(pStack3);
        }
        if (recipeType.getOutputsSize() > 1) {
            PositionedStack pStack4 = new PositionedStack((Object)recipeType.getOutput(1), 102 - offset, 35 - offset, false);
            outputs.add(pStack4);
        }
        if (recipeType.getOutputsSize() > 2) {
            PositionedStack pStack5 = new PositionedStack((Object)recipeType.getOutput(2), 120 - offset, 35 - offset, false);
            outputs.add(pStack5);
        }
    }

    @Override
    public String getRecipeName() {
        return Reference.industrialSawmillRecipe;
    }

    @Override
    public String getGuiTexture() {
        return "techreborn:textures/gui/industrial_sawmill.png";
    }

    @Override
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiIndustrialSawmill.class;
    }

    @Override
    public INeiBaseRecipe getNeiBaseRecipe() {
        return this;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 20, 25, 20), this.getNeiBaseRecipe().getRecipeName(), new Object[0]));
    }

    @Override
    public void drawBackground(int recipeIndex) {
        super.drawBackground(recipeIndex);
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (recipe instanceof GenericRecipeHander.CachedGenericRecipe && ((GenericRecipeHander.CachedGenericRecipe)recipe).recipie instanceof IndustrialSawmillRecipe) {
            IndustrialSawmillRecipe grinderRecipe = (IndustrialSawmillRecipe)((GenericRecipeHander.CachedGenericRecipe)recipe).recipie;
            if (grinderRecipe.fluidStack != null) {
                IIcon fluidIcon = grinderRecipe.fluidStack.getFluid().getIcon();
                if (fluidIcon != null) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                    int liquidHeight = grinderRecipe.fluidStack.amount * 100 / 16000;
                    GuiUtil.drawRepeated((IIcon)fluidIcon, (double)7.0, (double)(69 - liquidHeight), (double)14.0, (double)liquidHeight, (double)GuiDraw.gui.getZLevel());
                }
                GuiDraw.drawString((String)(grinderRecipe.fluidStack.amount + "mb of " + grinderRecipe.fluidStack.getLocalizedName()), (int)14, (int)135, (int)-1);
            }
        }
    }
}

