/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import techreborn.api.power.IEnergyItemInfo;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.powerSystem.PoweredItem;

public class ItemLithiumBatpack
extends ItemArmor
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.LithiumBatpackCharge;
    public static final int tier = ConfigTechReborn.LithiumBatpackTier;
    public double transferLimit = 10000.0;

    public ItemLithiumBatpack() {
        super(ItemArmor.ArmorMaterial.DIAMOND, 7, 1);
        this.func_77625_d(1);
        this.func_77655_b("techreborn.lithiumbatpack");
        this.func_77637_a(TechRebornCreativeTab.instance);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("techreborn:tool/lithiumBatpack");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "techreborn:textures/models/lithiumbatpack.png";
    }

    @Override
    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    @Override
    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    @Override
    public double getMaxTransfer(ItemStack stack) {
        return this.transferLimit;
    }

    @Override
    public int getStackTeir(ItemStack stack) {
        return tier;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        itemList.add(itemStack);
        ItemStack charged = new ItemStack((Item)this, 1);
        PoweredItem.setEnergy(this.getMaxPower(charged), charged);
        itemList.add(charged);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = PoweredItem.getEnergy(stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

