/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import reborncore.common.util.Color;
import techreborn.api.power.IEnergyItemInfo;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.powerSystem.PoweredItem;

public class ItemRockCutter
extends ItemPickaxe
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.RockCutterCharge;
    public int cost = 500;
    public static final int tier = ConfigTechReborn.RockCutterTier;

    public ItemRockCutter() {
        super(Item.ToolMaterial.EMERALD);
        this.func_77655_b("techreborn.rockcutter");
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77625_d(1);
        this.field_77864_a = 16.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("techreborn:tool/rockcutter");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack ist) {
        return true;
    }

    public void func_77624_a(ItemStack iS, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (!iS.func_77948_v()) {
            par3List.add(Color.WHITE + "Silk Touch I");
        }
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        if (Items.field_151046_w.canHarvestBlock(block, stack) && PoweredItem.canUseEnergy(this.cost, stack)) {
            PoweredItem.useEnergy(this.cost, stack);
            return true;
        }
        return false;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (!stack.func_77948_v()) {
            stack.func_77966_a(Enchantment.field_77348_q, 1);
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (!stack.func_77948_v()) {
            stack.func_77966_a(Enchantment.field_77348_q, 1);
        }
        return super.func_150893_a(stack, block);
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par1ItemStack.func_77966_a(Enchantment.field_77348_q, 1);
    }

    @Override
    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    @Override
    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxTransfer(ItemStack stack) {
        return 200.0;
    }

    @Override
    public int getStackTeir(ItemStack stack) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        itemList.add(itemStack);
        ItemStack charged = new ItemStack((Item)this, 1);
        PoweredItem.setEnergy(this.getMaxPower(charged), charged);
        itemList.add(charged);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = PoweredItem.getEnergy(stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

