/*
 * Decompiled with CFR 0.152.
 */
package techreborn.partSystem.QLib;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import reborncore.common.misc.Location;
import reborncore.common.misc.vecmath.Vecs3d;
import reborncore.common.misc.vecmath.Vecs3dCube;
import techreborn.partSystem.ModPart;
import techreborn.partSystem.QLib.ModLib2QLib;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartCollidable;
import uk.co.qmunity.lib.part.IPartRenderPlacement;
import uk.co.qmunity.lib.part.IPartSelectable;
import uk.co.qmunity.lib.part.IPartTicking;
import uk.co.qmunity.lib.part.IPartUpdateListener;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.PartBase;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.raytrace.RayTracer;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class QModPart
extends PartBase
implements IPartCollidable,
IPartSelectable,
IPartRenderPlacement,
IPartTicking,
IPartUpdateListener {
    ModPart iModPart;

    public QModPart(ModPart iModPart) {
        this.iModPart = iModPart;
    }

    public void setParent(ITilePartHolder parent) {
        super.setParent(parent);
    }

    public String getType() {
        return this.iModPart.getName();
    }

    public ItemStack getItem() {
        return this.iModPart.getItem();
    }

    public void addCollisionBoxesToList(List<Vec3dCube> boxes, Entity entity) {
        ArrayList cubes = new ArrayList();
        this.iModPart.addCollisionBoxesToList(cubes, entity);
        for (Vecs3dCube cube : cubes) {
            if (cube == null) continue;
            boxes.add(ModLib2QLib.convert(cube));
        }
    }

    public void renderDynamic(Vec3d translation, double delta, int pass) {
        this.iModPart.renderDynamic(ModLib2QLib.convert(translation), delta);
    }

    public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        return this.iModPart.renderStatic(new Vecs3d((double)translation.getX(), (double)translation.getY(), (double)translation.getZ()), pass);
    }

    public QMovingObjectPosition rayTrace(Vec3d start, Vec3d end) {
        return RayTracer.instance().rayTraceCubes((IPartSelectable)this, start, end);
    }

    public List<Vec3dCube> getSelectionBoxes() {
        return ModLib2QLib.convert2(this.iModPart.getSelectionBoxes());
    }

    public World getWorld() {
        return this.getParent().getWorld();
    }

    public void update() {
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.getWorld());
            this.iModPart.setLocation(new Location(this.getX(), this.getY(), this.getZ()));
        }
        this.iModPart.tick();
    }

    public void onPartChanged(IPart part) {
        this.iModPart.nearByChange();
    }

    public void onNeighborBlockChange() {
        this.iModPart.nearByChange();
    }

    public void onNeighborTileChange() {
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.getWorld());
            this.iModPart.setLocation(new Location(this.getX(), this.getY(), this.getZ()));
        }
        this.iModPart.nearByChange();
    }

    public void onAdded() {
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.getWorld());
            this.iModPart.setLocation(new Location(this.getX(), this.getY(), this.getZ()));
        }
        this.iModPart.nearByChange();
        this.iModPart.onAdded();
    }

    public void onRemoved() {
        this.iModPart.onRemoved();
    }

    public void onLoaded() {
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.getWorld());
            this.iModPart.setLocation(new Location(this.getX(), this.getY(), this.getZ()));
        }
        this.iModPart.nearByChange();
    }

    public void onUnloaded() {
    }

    public void onConverted() {
    }
}

