/*
 * Decompiled with CFR 0.152.
 */
package techreborn.partSystem.QLib;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.misc.Location;
import reborncore.common.misc.vecmath.Vecs3dCube;
import techreborn.partSystem.IModPart;
import techreborn.partSystem.IPartProvider;
import techreborn.partSystem.ModPart;
import techreborn.partSystem.ModPartRegistry;
import techreborn.partSystem.QLib.QModPart;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartFactory;
import uk.co.qmunity.lib.part.PartRegistry;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;
import uk.co.qmunity.lib.tile.TileMultipart;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class QModPartFactory
implements IPartFactory,
IPartProvider {
    public IPart createPart(String type, boolean client) {
        for (ModPart modPart : ModPartRegistry.parts) {
            if (!modPart.getName().equals(type)) continue;
            return new QModPart((ModPart)modPart.copy());
        }
        return null;
    }

    @Override
    public boolean placePart(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int face, float x_, float y_, float z_, ModPart modPart) {
        IPart part = this.createPart(item, player, world, new MovingObjectPosition(x, y, z, face, Vec3.func_72443_a((double)((float)x + x_), (double)((float)y + y_), (double)((float)z + z_))), modPart);
        if (part == null) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)face);
        return MultipartCompatibility.placePartInWorld((IPart)part, (World)world, (Vec3i)new Vec3i(x, y, z), (ForgeDirection)dir, (EntityPlayer)player, (ItemStack)item);
    }

    @Override
    public boolean isTileFromProvider(TileEntity tileEntity) {
        return tileEntity instanceof TileMultipart;
    }

    @Override
    public IModPart getPartFromWorld(World world, Location location, String name) {
        IPart part = MultipartCompatibility.getPart((World)world, (int)location.getX(), (int)location.getY(), (int)location.getZ(), (String)name);
        if (part != null && part instanceof QModPart) {
            return ((QModPart)part).iModPart;
        }
        return null;
    }

    @Override
    public void init() {
    }

    public String getCreatedPartType(ItemStack item, EntityPlayer player, World world, MovingObjectPosition mop, ModPart modPart) {
        return modPart.getName();
    }

    public IPart createPart(ItemStack item, EntityPlayer player, World world, MovingObjectPosition mop, ModPart modPart) {
        return PartRegistry.createPart((String)this.getCreatedPartType(item, player, world, mop, modPart), (boolean)world.field_72995_K);
    }

    @Override
    public String modID() {
        return "qmunitylib";
    }

    @Override
    public void registerPart() {
        PartRegistry.registerFactory((IPartFactory)new QModPartFactory());
    }

    @Override
    public boolean checkOcclusion(World world, Location location, Vecs3dCube cube) {
        return MultipartCompatibility.checkOcclusion((World)world, (int)location.x, (int)location.y, (int)location.z, (Vec3dCube)new Vec3dCube(cube.toAABB()));
    }

    @Override
    public boolean hasPart(World world, Location location, String name) {
        if (MultipartCompatibility.getPartHolder((World)world, (int)location.getX(), (int)location.getY(), (int)location.getZ()) == null) {
            return false;
        }
        return MultipartCompatibility.getPart((World)world, (int)location.getX(), (int)location.getY(), (int)location.getZ(), (String)name) == null;
    }
}

