/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.util.Inventory;
import techreborn.api.recipe.RecipeCrafter;
import techreborn.init.ModBlocks;
import techreborn.lib.Reference;
import techreborn.powerSystem.TilePowerAcceptor;

public class TileChemicalReactor
extends TilePowerAcceptor
implements IWrenchable,
IInventory,
ISidedInventory {
    public int tickTime;
    public Inventory inventory = new Inventory(8, "TileChemicalReactor", 64);
    public RecipeCrafter crafter;

    public TileChemicalReactor() {
        super(2);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2};
        this.crafter = new RecipeCrafter(Reference.chemicalReactorRecipe, this, 2, 2, this.inventory, inputs, outputs);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.crafter.updateEntity();
        this.charge(3);
    }

    public void charge(int slot) {
        if (this.func_70301_a(slot) != null && this.func_70301_a(slot).func_77973_b() instanceof IElectricItem && this.getEnergy() != this.getMaxPower()) {
            ItemStack stack = this.inventory.func_70301_a(slot);
            double MaxCharge = ((IElectricItem)stack.func_77973_b()).getMaxCharge(stack);
            double CurrentCharge = ElectricItem.manager.getCharge(stack);
            if (CurrentCharge != 0.0) {
                ElectricItem.manager.discharge(stack, 5.0, 4, false, false, false);
                this.addEnergy(5.0);
            }
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ChemicalReactor, 1);
    }

    public boolean isComplete() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        this.crafter.writeToNBT(tagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == ForgeDirection.DOWN.ordinal()) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        if (slotIndex == 2) {
            return false;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return slotIndex == 2;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    @Override
    public double getMaxPower() {
        return 10000.0;
    }

    @Override
    public boolean canAcceptEnergy(ForgeDirection direction) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ForgeDirection direction) {
        return false;
    }

    @Override
    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public double getMaxInput() {
        return 128.0;
    }
}

