/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.recipe;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.recipe.IBaseRecipeType;
import techreborn.api.recipe.RecipeHandler;

public class RecipeCrafter {
    public String recipeName;
    public TileMachineBase parentTile;
    public IEnergyInterfaceTile energy;
    public int inputs;
    public int outputs;
    public Inventory inventory;
    public int[] inputSlots;
    public int[] outputSlots;
    public IBaseRecipeType currentRecipe;
    public int currentTickTime = 0;
    public int currentNeededTicks = 1;
    double lastEnergy;
    double speedMultiplier = 0.0;
    double powerMultiplier = 1.0;
    int ticksSinceLastChange;

    public RecipeCrafter(String recipeName, TileMachineBase parentTile, int inputs, int outputs, Inventory inventory, int[] inputSlots, int[] outputSlots) {
        this.recipeName = recipeName;
        this.parentTile = parentTile;
        if (parentTile instanceof IEnergyInterfaceTile) {
            this.energy = (IEnergyInterfaceTile)parentTile;
        }
        this.inputs = inputs;
        this.outputs = outputs;
        this.inventory = inventory;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
    }

    public void updateEntity() {
        if (this.parentTile.func_145831_w().field_72995_K) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (this.ticksSinceLastChange == 20) {
            this.inventory.hasChanged = true;
            this.ticksSinceLastChange = 0;
        }
        if (this.currentRecipe == null && this.inventory.hasChanged) {
            this.currentTickTime = 0;
            for (IBaseRecipeType recipe : RecipeHandler.getRecipeClassFromName(this.recipeName)) {
                if (!recipe.canCraft((TileEntity)this.parentTile) || !this.hasAllInputs(recipe)) continue;
                boolean canGiveInvAll = true;
                for (int i = 0; i < recipe.getOutputsSize(); ++i) {
                    if (this.canFitStack(recipe.getOutput(i), this.outputSlots[i], recipe.useOreDic())) continue;
                    canGiveInvAll = false;
                    return;
                }
                if (canGiveInvAll) {
                    this.setCurrentRecipe(recipe);
                    this.currentNeededTicks = (int)((double)this.currentRecipe.tickTime() * (1.0 - this.speedMultiplier));
                    this.currentTickTime = -1;
                    this.setIsActive();
                    continue;
                }
                this.currentTickTime = -1;
            }
        } else {
            if (this.inventory.hasChanged && !this.hasAllInputs()) {
                this.currentRecipe = null;
                this.currentTickTime = -1;
                this.setIsActive();
            }
            if (this.currentRecipe != null && this.currentTickTime >= this.currentNeededTicks) {
                boolean canGiveInvAll = true;
                for (int i = 0; i < this.currentRecipe.getOutputsSize(); ++i) {
                    if (this.canFitStack(this.currentRecipe.getOutput(i), this.outputSlots[i], this.currentRecipe.useOreDic())) continue;
                    canGiveInvAll = false;
                }
                ArrayList<Integer> filledSlots = new ArrayList<Integer>();
                if (canGiveInvAll && this.currentRecipe.onCraft((TileEntity)this.parentTile)) {
                    for (int i = 0; i < this.currentRecipe.getOutputsSize(); ++i) {
                        if (filledSlots.contains(this.outputSlots[i])) continue;
                        this.fitStack(this.currentRecipe.getOutput(i).func_77946_l(), this.outputSlots[i]);
                        filledSlots.add(this.outputSlots[i]);
                    }
                    this.useAllInputs();
                    this.currentRecipe = null;
                    this.currentTickTime = -1;
                    this.setIsActive();
                }
            } else if (this.currentRecipe != null && this.currentTickTime < this.currentNeededTicks && this.energy.canUseEnergy(this.getEuPerTick())) {
                this.energy.useEnergy(this.getEuPerTick());
                ++this.currentTickTime;
            }
        }
        if (this.inventory.hasChanged) {
            this.inventory.hasChanged = false;
        }
    }

    public boolean hasAllInputs() {
        if (this.currentRecipe == null) {
            return false;
        }
        for (ItemStack input : this.currentRecipe.getInputs()) {
            Boolean hasItem = false;
            for (int inputSlot : this.inputSlots) {
                if (!ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.inventory.func_70301_a(inputSlot), (boolean)true, (boolean)true, (boolean)this.currentRecipe.useOreDic()) || this.inventory.func_70301_a((int)inputSlot).field_77994_a < input.field_77994_a) continue;
                hasItem = true;
            }
            if (hasItem.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllInputs(IBaseRecipeType recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (ItemStack input : recipeType.getInputs()) {
            Boolean hasItem = false;
            for (int inputslot : this.inputSlots) {
                if (!ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.inventory.func_70301_a(inputslot), (boolean)true, (boolean)true, (boolean)recipeType.useOreDic()) || this.inventory.func_70301_a((int)inputslot).field_77994_a < input.field_77994_a) continue;
                hasItem = true;
            }
            if (hasItem.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void useAllInputs() {
        if (this.currentRecipe == null) {
            return;
        }
        block0: for (ItemStack input : this.currentRecipe.getInputs()) {
            for (int inputSlot : this.inputSlots) {
                if (!ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.inventory.func_70301_a(inputSlot), (boolean)true, (boolean)true, (boolean)this.currentRecipe.useOreDic())) continue;
                this.inventory.func_70298_a(inputSlot, input.field_77994_a);
                continue block0;
            }
        }
    }

    public boolean canFitStack(ItemStack stack, int slot, boolean oreDic) {
        if (stack == null) {
            return true;
        }
        if (this.inventory.func_70301_a(slot) == null) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(slot), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)oreDic) && stack.field_77994_a + this.inventory.func_70301_a((int)slot).field_77994_a <= stack.func_77976_d();
    }

    public void fitStack(ItemStack stack, int slot) {
        if (stack == null) {
            return;
        }
        if (this.inventory.func_70301_a(slot) == null) {
            this.inventory.func_70299_a(slot, stack);
            return;
        }
        if (ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(slot), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)this.currentRecipe.useOreDic()) && stack.field_77994_a + this.inventory.func_70301_a((int)slot).field_77994_a <= stack.func_77976_d()) {
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = this.inventory.func_70301_a((int)slot).field_77994_a + stack.field_77994_a;
            this.inventory.func_70299_a(slot, newStack);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound data = tag.func_74775_l("Crater");
        if (data.func_74764_b("currentTickTime")) {
            this.currentTickTime = data.func_74762_e("currentTickTime");
        }
        if (this.parentTile != null && this.parentTile.func_145831_w() != null && this.parentTile.func_145831_w().field_72995_K) {
            this.parentTile.func_145831_w().func_175689_h(this.parentTile.func_174877_v());
            this.parentTile.func_145831_w().func_147458_c(this.parentTile.func_174877_v().func_177958_n(), this.parentTile.func_174877_v().func_177956_o(), this.parentTile.func_174877_v().func_177952_p(), this.parentTile.func_174877_v().func_177958_n(), this.parentTile.func_174877_v().func_177956_o(), this.parentTile.func_174877_v().func_177952_p());
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("currentTickTime", (double)this.currentTickTime);
        tag.func_74782_a("Crater", (NBTBase)data);
    }

    private boolean isActive() {
        return this.currentRecipe != null && this.energy.getEnergy() >= (double)this.currentRecipe.euPerTick();
    }

    public void addSpeedMulti(double amount) {
        this.speedMultiplier = this.speedMultiplier + amount <= 0.99 ? (this.speedMultiplier += amount) : 0.99;
    }

    public void resetSpeedMulti() {
        this.speedMultiplier = 0.0;
    }

    public double getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public void addPowerMulti(double amount) {
        this.powerMultiplier += amount;
    }

    public void resetPowerMulti() {
        this.powerMultiplier = 1.0;
    }

    public double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public double getEuPerTick() {
        return (double)this.currentRecipe.euPerTick() * this.powerMultiplier;
    }

    public void setIsActive() {
        if (this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()).func_177230_c() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()).func_177230_c();
            blockMachineBase.setActive(Boolean.valueOf(this.isActive()), this.parentTile.func_145831_w(), this.parentTile.func_174877_v());
        }
        this.parentTile.func_145831_w().func_175689_h(this.parentTile.func_174877_v());
    }

    public void setCurrentRecipe(IBaseRecipeType recipe) {
        try {
            this.currentRecipe = (IBaseRecipeType)recipe.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }
}

