/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import java.util.List;
import java.util.Random;
import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.BaseTileBlock;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.TilePlayerDectector;

public class BlockPlayerDetector
extends BaseTileBlock
implements ITexturedBlock {
    public PropertyInteger METADATA;
    public static final String[] types = new String[]{"all", "others", "you"};

    public BlockPlayerDetector() {
        super(Material.field_151576_e);
        this.func_149663_c("techreborn.playerDetector");
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.METADATA, (Comparable)Integer.valueOf(0)));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TilePlayerDectector();
    }

    public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_180656_a(IBlockAccess blockAccess, BlockPos pos, IBlockState state, EnumFacing side) {
        TileEntity entity = blockAccess.func_175625_s(pos);
        if (entity instanceof TilePlayerDectector) {
            return ((TilePlayerDectector)entity).isProvidingPower() ? 15 : 0;
        }
        return 0;
    }

    public int func_176211_b(IBlockAccess blockAccess, BlockPos pos, IBlockState state, EnumFacing side) {
        TileEntity entity = blockAccess.func_175625_s(pos);
        if (entity instanceof TilePlayerDectector) {
            return ((TilePlayerDectector)entity).isProvidingPower() ? 15 : 0;
        }
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TilePlayerDectector) {
            ((TilePlayerDectector)tile).owenerUdid = placer.func_110124_au().toString();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        int newMeta = this.func_176201_c(state);
        String message = "";
        switch (newMeta) {
            case 0: {
                message = EnumChatFormatting.GREEN + "Detects all Players";
                break;
            }
            case 1: {
                message = EnumChatFormatting.RED + "Detects only other Players";
                break;
            }
            case 2: {
                message = EnumChatFormatting.BLUE + "Detects only you";
            }
        }
        if (!world.field_72995_K) {
            entityplayer.func_146105_b((IChatComponent)new ChatComponentText(message));
        }
        return true;
    }

    public String getTextureNameFromState(IBlockState blockState, EnumFacing facing) {
        return "techreborn:blocks/machine/greg_machines/player_detector_" + types[this.func_176201_c(blockState)];
    }

    public int amountOfStates() {
        return types.length;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.METADATA);
    }

    protected BlockState func_180661_e() {
        this.METADATA = PropertyInteger.func_177719_a((String)"Type", (int)0, (int)(types.length - 1));
        return new BlockState((Block)this, new IProperty[]{this.METADATA});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.METADATA, (Comparable)Integer.valueOf(meta));
    }
}

