/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import reborncore.RebornCore;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.items.ItemParts;
import techreborn.items.tools.ItemTreeTap;

public class BlockRubberLog
extends Block
implements ITexturedBlock {
    public static PropertyDirection SAP_SIDE = PropertyDirection.func_177712_a((String)"sapSide", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyBool HAS_SAP = PropertyBool.func_177716_a((String)"hasSap");

    public BlockRubberLog() {
        super(Material.field_151575_d);
        this.func_149663_c("techreborn.rubberlog");
        this.func_149647_a(TechRebornCreativeTabMisc.instance);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
        RebornCore.jsonDestroyer.registerObject((Object)this);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SAP_SIDE, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{SAP_SIDE, HAS_SAP});
    }

    public IBlockState func_176203_a(int meta) {
        boolean hasSap = false;
        int tempMeta = meta;
        if (meta > 3) {
            hasSap = true;
            tempMeta -= 3;
        }
        EnumFacing facing = EnumFacing.func_176731_b((int)tempMeta);
        return this.func_176223_P().func_177226_a((IProperty)SAP_SIDE, (Comparable)facing).func_177226_a((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(hasSap));
    }

    public int func_176201_c(IBlockState state) {
        int tempMeta = 0;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)SAP_SIDE);
        switch (facing) {
            case SOUTH: {
                tempMeta = 0;
                break;
            }
            case WEST: {
                tempMeta = 1;
                break;
            }
            case NORTH: {
                tempMeta = 2;
                break;
            }
            case EAST: {
                tempMeta = 3;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)HAS_SAP)).booleanValue()) {
            tempMeta += 3;
        }
        return tempMeta;
    }

    public String getTextureNameFromState(IBlockState iBlockState, EnumFacing enumFacing) {
        if (enumFacing == EnumFacing.DOWN || enumFacing == EnumFacing.UP) {
            return "techreborn:blocks/rubber_log_top";
        }
        if (((Boolean)iBlockState.func_177229_b((IProperty)HAS_SAP)).booleanValue() && iBlockState.func_177229_b((IProperty)SAP_SIDE) == enumFacing) {
            return "techreborn:blocks/rubber_log_sap";
        }
        return "techreborn:blocks/rubber_log_side";
    }

    public int amountOfStates() {
        return 8;
    }

    public boolean canSustainLeaves(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int i = 4;
        int j = i + 1;
        if (worldIn.func_175707_a(pos.func_177982_a(-j, -j, -j), pos.func_177982_a(j, j, j))) {
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-i, -i, -i), (BlockPos)pos.func_177982_a(i, i, i))) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                if (!iblockstate.func_177230_c().isLeaves((IBlockAccess)worldIn, blockpos)) continue;
                iblockstate.func_177230_c().beginLeavesDecay(worldIn, blockpos);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!((Boolean)state.func_177229_b((IProperty)HAS_SAP)).booleanValue() && rand.nextInt(50) == 0) {
            EnumFacing facing = EnumFacing.func_176731_b((int)rand.nextInt(4));
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SAP_SIDE, (Comparable)facing));
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        super.func_180639_a(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
        if (playerIn.func_71045_bC() != null && playerIn.func_71045_bC().func_77973_b() instanceof ItemTreeTap && ((Boolean)state.func_177229_b((IProperty)HAS_SAP)).booleanValue() && state.func_177229_b((IProperty)SAP_SIDE) == side) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SAP_SIDE, (Comparable)EnumFacing.func_176731_b((int)0)));
            worldIn.func_72956_a((Entity)playerIn, "techreborn:sap_extract", 0.8f, 1.0f);
            if (!worldIn.field_72995_K) {
                Random rand = new Random();
                BlockPos itemPos = pos.func_177972_a(side);
                EntityItem item = new EntityItem(worldIn, (double)itemPos.func_177958_n(), (double)itemPos.func_177956_o(), (double)itemPos.func_177952_p(), ItemParts.getPartByName("rubberSap").func_77946_l());
                float factor = 0.05f;
                playerIn.func_71045_bC().func_77972_a(1, (EntityLivingBase)playerIn);
                item.field_70159_w = rand.nextGaussian() * (double)factor;
                item.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
                item.field_70179_y = rand.nextGaussian() * (double)factor;
                worldIn.func_72838_d((Entity)item);
            }
            return true;
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((Block)this));
        if (((Boolean)state.func_177229_b((IProperty)HAS_SAP)).booleanValue() && new Random().nextInt(4) == 0) {
            drops.add(ItemParts.getPartByName("rubberSap"));
        }
        return drops;
    }
}

