/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat;

import java.util.ArrayList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import techreborn.client.render.parts.ClientPartLoader;
import techreborn.compat.ICompatModule;
import techreborn.compat.minetweaker.MinetweakerCompat;
import techreborn.compat.recipes.RecipesBiomesOPlenty;
import techreborn.compat.recipes.RecipesBuildcraft;
import techreborn.compat.recipes.RecipesThaumcraft;
import techreborn.compat.waila.CompatModuleWaila;
import techreborn.config.ConfigTechReborn;
import techreborn.parts.StandalonePartCompact;
import techreborn.parts.TechRebornParts;
import techreborn.parts.walia.WailaMcMultiPartCompact;

public class CompatManager {
    public ArrayList<ICompatModule> compatModules = new ArrayList();
    public static CompatManager INSTANCE = new CompatManager();
    public static boolean isIC2Loaded = false;
    public static boolean isIC2ClassicLoaded = false;
    public static boolean isClassicEnet = false;
    public static boolean isGregTechLoaded = false;

    public CompatManager() {
        isIC2Loaded = Loader.isModLoaded((String)"IC2");
        isIC2ClassicLoaded = false;
        if (isIC2ClassicLoaded) {
            isClassicEnet = true;
        }
        if (Loader.isModLoaded((String)"Uncomplication")) {
            isClassicEnet = true;
        }
        if (Loader.isModLoaded((String)"gregtech")) {
            isGregTechLoaded = true;
        }
        this.registerCompact(CompatModuleWaila.class, "Waila");
        this.registerCompact(MinetweakerCompat.class, "MineTweaker3");
        this.registerCompact(RecipesBiomesOPlenty.class, "BiomesOPlenty");
        this.registerCompact(RecipesBuildcraft.class, "BuildCraft|Builders");
        this.registerCompact(RecipesThaumcraft.class, "Thaumcraft");
        this.registerCompact(TechRebornParts.class, "mcmultipart", "!IC2");
        this.registerCompact(ClientPartLoader.class, "mcmultipart", "@client", "!IC2");
        this.registerCompact(StandalonePartCompact.class, "!mcmultipart", "!IC2");
        this.registerCompact(WailaMcMultiPartCompact.class, "mcmultipart", "Waila", "!IC2");
    }

    public void registerCompact(Class<? extends ICompatModule> moduleClass, Object ... objs) {
        boolean shouldLoad = ConfigTechReborn.config.get(ConfigTechReborn.CATEGORY_INTEGRATION, "Compat:" + moduleClass.getSimpleName(), true, "Should the " + moduleClass.getSimpleName() + " be loaded?").getBoolean(true);
        if (ConfigTechReborn.config.hasChanged()) {
            ConfigTechReborn.config.save();
        }
        if (!shouldLoad) {
            return;
        }
        for (Object obj : objs) {
            if (obj instanceof String) {
                String modid = (String)obj;
                if (!(modid.startsWith("@") ? modid.equals("@client") && FMLCommonHandler.instance().getSide() != Side.CLIENT : (modid.startsWith("!") ? Loader.isModLoaded((String)modid.replaceAll("!", "")) : !Loader.isModLoaded((String)modid)))) continue;
                return;
            }
            if (!(obj instanceof Boolean)) continue;
            Boolean boo = (Boolean)obj;
            if (!boo.booleanValue()) {
                // empty if block
            }
            return;
        }
        try {
            this.compatModules.add(moduleClass.newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public boolean isForestry4() {
        try {
            Class.forName("forestry.api.arboriculture.EnumWoodType");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

