/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.items.ItemIngots;

public class ModLoot {
    public static WeightedRandomChestContent rubberSaplingLoot = new WeightedRandomChestContent(new ItemStack(ModBlocks.rubberSapling), 1, 3, 25);
    public static WeightedRandomChestContent copperIngotLoot = new WeightedRandomChestContent(ItemIngots.getIngotByName("copper"), 1, 4, 20);
    public static WeightedRandomChestContent tinIngotLoot = new WeightedRandomChestContent(ItemIngots.getIngotByName("tin"), 1, 4, 20);
    public static WeightedRandomChestContent steelIngotLoot = new WeightedRandomChestContent(ItemIngots.getIngotByName("steel"), 1, 3, 5);

    public static void init() {
        if (ConfigTechReborn.RubberSaplingLoot) {
            ModLoot.generate(rubberSaplingLoot);
        }
        if (ConfigTechReborn.CopperIngotsLoot) {
            ModLoot.generate(copperIngotLoot);
        }
        if (ConfigTechReborn.TinIngotsLoot) {
            ModLoot.generate(tinIngotLoot);
        }
        if (ConfigTechReborn.SteelIngotsLoot) {
            ModLoot.generate(steelIngotLoot);
        }
    }

    public static void generate(WeightedRandomChestContent chestContent) {
        for (String category : Arrays.asList("villageBlacksmith", "mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "pyramidJungleDispenser", "strongholdCorridor", "strongholdLibrary", "strongholdCrossing", "bonusChest", "dungeonChest")) {
            ChestGenHooks.addItem((String)category, (WeightedRandomChestContent)chestContent);
        }
    }
}

