/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import ic2.api.info.Info;
import ic2.api.item.IC2Items;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import techreborn.api.recipe.IRecipeCompact;
import techreborn.blocks.BlockMachineFrame;
import techreborn.compat.CompatManager;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemCells;
import techreborn.items.ItemIngots;
import techreborn.items.ItemParts;
import techreborn.items.ItemPlates;
import techreborn.parts.ItemStandaloneCables;

public class RecipeCompact
implements IRecipeCompact {
    HashMap<String, ItemStack> recipes = new HashMap();
    ArrayList<String> missingItems = new ArrayList();
    HashMap<String, Ic2ItemValue> ic2RenameDictionary = new HashMap();
    boolean inited = false;

    public void init() {
        this.recipes.put("industrialDiamond", new ItemStack(Items.field_151045_i));
        this.recipes.put("industrialTnt", new ItemStack(Blocks.field_150335_W));
        this.recipes.put("copperIngot", ItemIngots.getIngotByName("copper"));
        this.recipes.put("tinIngot", ItemIngots.getIngotByName("tin"));
        this.recipes.put("bronzeIngot", ItemIngots.getIngotByName("bronze"));
        this.recipes.put("leadIngot", ItemIngots.getIngotByName("lead"));
        this.recipes.put("silverIngot", ItemIngots.getIngotByName("silver"));
        this.recipes.put("iridiumOre", ItemIngots.getIngotByName("Iridium"));
        this.recipes.put("plateiron", ItemPlates.getPlateByName("iron"));
        this.recipes.put("iridiumPlate", ItemPlates.getPlateByName("iridium"));
        this.recipes.put("cell", ItemCells.getCellByName("empty"));
        this.recipes.put("airCell", ItemCells.getCellByName("empty"));
        this.recipes.put("electronicCircuit", ItemParts.getPartByName("electronicCircuit"));
        this.recipes.put("advancedCircuit", ItemParts.getPartByName("advancedCircuit"));
        this.recipes.put("rubberWood", new ItemStack(ModBlocks.rubberLog));
        this.recipes.put("resin", ItemParts.getPartByName("rubberSap"));
        this.recipes.put("carbonPlate", ItemPlates.getPlateByName("carbon"));
        this.recipes.put("reBattery", new ItemStack(ModItems.reBattery));
        this.recipes.put("machine", BlockMachineFrame.getFrameByName("machine", 1));
        this.recipes.put("advancedMachine", BlockMachineFrame.getFrameByName("advancedMachine", 1));
        this.recipes.put("extractor", new ItemStack(ModBlocks.Extractor));
        this.recipes.put("generator", new ItemStack(ModBlocks.Generator));
        this.recipes.put("macerator", new ItemStack(ModBlocks.Grinder));
        this.recipes.put("diamondDrill", new ItemStack(ModItems.diamondDrill));
        this.recipes.put("miningDrill", new ItemStack(ModItems.ironDrill));
        this.recipes.put("solarPanel", new ItemStack(ModBlocks.solarPanel));
        this.recipes.put("waterCell", ItemCells.getCellByName("water"));
        this.recipes.put("lavaCell", ItemCells.getCellByName("lava"));
        this.recipes.put("pump", ItemParts.getPartByName("pump"));
        this.recipes.put("teleporter", ItemParts.getPartByName("teleporter"));
        this.recipes.put("advancedAlloy", ItemParts.getPartByName("advancedAlloy"));
        this.recipes.put("lvTransformer", new ItemStack(ModBlocks.lvt));
        this.recipes.put("mvTransformer", new ItemStack(ModBlocks.mvt));
        this.recipes.put("hvTransformer", new ItemStack(ModBlocks.hvt));
        this.recipes.put("windMill", new ItemStack(ModBlocks.windMill));
        this.recipes.put("energyCrystal", new ItemStack(ModItems.energyCrystal));
        this.ic2RenameDictionary.put("plateiron", new Ic2ItemValue("plate", "iron"));
        this.inited = true;
    }

    public static ItemStack getCableByName(String name) {
        return RecipeCompact.getCableByName(name, 1);
    }

    public static ItemStack getCableByName(String name, int count) {
        if (Info.isIc2Available()) {
            return new ItemStack(ModItems.missingRecipe);
        }
        return ItemStandaloneCables.getCableByName(name, count);
    }

    @Override
    public ItemStack getItem(String name) {
        if (!this.inited) {
            this.init();
        }
        if (CompatManager.isIC2Loaded) {
            Ic2ItemValue newVaule = null;
            if (this.ic2RenameDictionary.containsKey(name)) {
                newVaule = this.ic2RenameDictionary.get(name);
            }
            if (newVaule == null) {
                ItemStack stack = IC2Items.getItem((String)name);
                if (stack == null || stack.func_77973_b() == null) {
                    throw new InvalidParameterException("could not find " + name + " in the ic2 api");
                }
                return stack;
            }
            boolean requiresVariant = false;
            ItemStack stack = IC2Items.getItem((String)newVaule.item);
            if (!newVaule.variant.equals("null")) {
                stack = IC2Items.getItem((String)newVaule.item, (String)newVaule.variant);
            }
            if (stack == null || stack.func_77973_b() == null) {
                throw new InvalidParameterException("could not find " + name + " in the ic2 api");
            }
            return stack;
        }
        if (!this.recipes.containsKey(name)) {
            if (!this.missingItems.contains(name)) {
                this.missingItems.add(name);
            }
            return new ItemStack(ModItems.missingRecipe);
        }
        return this.recipes.get(name);
    }

    public void saveMissingItems(File mcDir) throws IOException {
        File missingItemsFile = new File(mcDir, "missingItems.txt");
        if (missingItemsFile.exists()) {
            missingItemsFile.delete();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(missingItemsFile));
        for (String str : this.missingItems) {
            writer.write(str);
            writer.newLine();
        }
        writer.close();
    }

    class Ic2ItemValue {
        String item;
        String variant = "null";

        public Ic2ItemValue(String item, String variant) {
            this.item = item;
            this.variant = variant;
        }

        public Ic2ItemValue(String item) {
            this.item = item;
        }
    }
}

