/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemParts;
import techreborn.items.ItemPlates;
import techreborn.manual.PageCollection;
import techreborn.manual.pages.AdvancedMachines;
import techreborn.manual.pages.BasicMachinesPage;
import techreborn.manual.pages.ContentsPage;
import techreborn.manual.pages.CraftingInfoPage;
import techreborn.manual.pages.DescriptionPage;
import techreborn.manual.pages.GeneratingPowerPage;
import techreborn.manual.pages.GettingStartedPage;
import techreborn.manual.pages.ToolsPage;

@SideOnly(value=Side.CLIENT)
public class GuiManual
extends GuiScreen {
    protected final PageCollection root = this.createRoot();
    protected int pageIndex = 0;
    protected int xSize = 146;
    protected int ySize = 180;
    public Container inventorySlots;
    protected int guiLeft;
    protected int guiTop;

    protected PageCollection createRoot() {
        this.pageIndex = 0;
        PageCollection pageCollection = new PageCollection();
        pageCollection.addPage(new ContentsPage("contents", pageCollection));
        pageCollection.addPage(new GettingStartedPage("gettingstarted", pageCollection));
        pageCollection.addPage(new DescriptionPage("gettingrubber", pageCollection, true, "gettingrubber2"));
        pageCollection.addPage(new CraftingInfoPage("gettingrubber2", pageCollection, ItemParts.getPartByName("rubber"), "", "gettingrubber"));
        pageCollection.addPage(new CraftingInfoPage("gettingplates", pageCollection, ItemPlates.getPlateByName("iron"), "", "gettingstarted"));
        pageCollection.addPage(new GeneratingPowerPage("generatingpower", pageCollection));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.Generator.func_149732_F(), pageCollection, new ItemStack(ModBlocks.Generator), "", "generatingpower"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.thermalGenerator.func_149732_F(), pageCollection, new ItemStack(ModBlocks.thermalGenerator), "", "generatingpower"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.solarPanel.func_149732_F(), pageCollection, new ItemStack(ModBlocks.solarPanel), "", "generatingpower"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.heatGenerator.func_149732_F(), pageCollection, new ItemStack(ModBlocks.heatGenerator), "", "generatingpower"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.LightningRod.func_149732_F(), pageCollection, new ItemStack(ModBlocks.LightningRod), "", "generatingpower"));
        pageCollection.addPage(new BasicMachinesPage("basicmachines", pageCollection));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.Grinder.func_149732_F(), pageCollection, new ItemStack(ModBlocks.Grinder), "", "basicmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.ElectricFurnace.func_149732_F(), pageCollection, new ItemStack(ModBlocks.ElectricFurnace), "", "basicmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.AlloySmelter.func_149732_F(), pageCollection, new ItemStack(ModBlocks.AlloySmelter), "", "basicmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.Extractor.func_149732_F(), pageCollection, new ItemStack(ModBlocks.Extractor), "", "basicmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.Compressor.func_149732_F(), pageCollection, new ItemStack(ModBlocks.Compressor), "", "basicmachines"));
        pageCollection.addPage(new AdvancedMachines("advancedmachines", pageCollection));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.BlastFurnace.func_149732_F(), pageCollection, new ItemStack(ModBlocks.BlastFurnace), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.industrialSawmill.func_149732_F(), pageCollection, new ItemStack(ModBlocks.industrialSawmill), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.IndustrialElectrolyzer.func_149732_F(), pageCollection, new ItemStack(ModBlocks.IndustrialElectrolyzer), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.IndustrialGrinder.func_149732_F(), pageCollection, new ItemStack(ModBlocks.IndustrialGrinder), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.ImplosionCompressor.func_149732_F(), pageCollection, new ItemStack(ModBlocks.ImplosionCompressor), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.centrifuge.func_149732_F(), pageCollection, new ItemStack(ModBlocks.centrifuge), "", "advancedmachines"));
        pageCollection.addPage(new ToolsPage("tools", pageCollection));
        pageCollection.addPage(new CraftingInfoPage(ModItems.ironDrill.func_77658_a() + ".name", pageCollection, new ItemStack(ModItems.ironDrill), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.diamondDrill.func_77658_a() + ".name", pageCollection, new ItemStack(ModItems.diamondDrill), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.advancedDrill.func_77658_a() + ".name", pageCollection, new ItemStack(ModItems.advancedDrill), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.ironChainsaw.func_77658_a() + ".name", pageCollection, new ItemStack(ModItems.ironChainsaw), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.diamondChainsaw.func_77658_a() + ".name", pageCollection, new ItemStack(ModItems.diamondChainsaw), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.advancedChainsaw.func_77658_a() + ".name", pageCollection, new ItemStack(ModItems.advancedChainsaw), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.omniTool.func_77658_a() + ".name", pageCollection, new ItemStack(ModItems.omniTool), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.treeTap.func_77658_a() + ".name", pageCollection, new ItemStack(ModItems.treeTap), "", "tools"));
        return pageCollection;
    }

    private int getNextPageIndex() {
        int i = this.pageIndex++;
        return i;
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        this.drawGuiBackgroundLayer(par3, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, par3);
        this.prepareRenderState();
        GL11.glPushMatrix();
        this.root.drawScreen(this.field_146297_k, this.guiLeft, this.guiTop, mouseX - this.guiLeft, mouseY - this.guiTop);
        GL11.glPopMatrix();
        this.restoreRenderState();
    }

    protected void prepareRenderState() {
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    protected void restoreRenderState() {
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    protected void drawGuiBackgroundLayer(float p_146976_1_, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.guiLeft, (double)this.guiTop, (double)0.0);
        this.root.renderBackgroundLayer(this.field_146297_k, 0, 0, mouseX - this.guiLeft, mouseY - this.guiTop);
        GL11.glPopMatrix();
    }

    public void func_146280_a(Minecraft minecraft, int x, int y) {
        super.func_146280_a(minecraft, x, y);
        this.root.setWorldAndResolution(minecraft, x, y);
    }

    public void func_146284_a(GuiButton button) {
        this.root.actionPerformed(button);
    }

    public void func_73864_a(int par1, int par2, int par3) throws IOException {
        this.root.mouseClicked(par1, par2, par3);
    }

    public void func_146269_k() throws IOException {
        super.func_146269_k();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public boolean func_73868_f() {
        return false;
    }
}

