/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import techreborn.manual.pages.BasePage;

public class PageCollection
extends Gui {
    public final List<BasePage> pages = Lists.newArrayList();
    private String ACTIVE_PAGE = "contents";
    protected int x = 0;
    protected int y = 0;

    public void addPage(BasePage page) {
        this.pages.add(page);
    }

    public BasePage getPageByName(String name) {
        for (BasePage component : this.pages) {
            if (!component.getReferenceName().equals(this.ACTIVE_PAGE)) continue;
            return component;
        }
        return null;
    }

    public BasePage getActivePage() {
        for (BasePage component : this.pages) {
            if (!component.getReferenceName().equals(this.ACTIVE_PAGE)) continue;
            return component;
        }
        return null;
    }

    public final void drawScreen(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.getActivePage() == null) {
            return;
        }
        this.getActivePage().drawScreen(minecraft, offsetX, offsetY, mouseX, mouseY);
    }

    public final void renderBackgroundLayer(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.getActivePage() == null) {
            return;
        }
        this.getActivePage().renderBackgroundLayer(minecraft, offsetX, offsetY, mouseX, mouseY);
    }

    public void changeActivePage(String newPage) {
        this.ACTIVE_PAGE = newPage;
        if (this.getActivePage() == null) {
            return;
        }
        this.getActivePage().func_146280_a(Minecraft.func_71410_x(), this.x, this.y);
    }

    public void setWorldAndResolution(Minecraft minecraft, int x, int y) {
        if (this.getActivePage() == null) {
            return;
        }
        this.getActivePage().func_146280_a(minecraft, x, y);
        this.x = x;
        this.y = y;
    }

    protected void actionPerformed(GuiButton button) {
        if (this.getActivePage() == null) {
            return;
        }
        this.getActivePage().func_146284_a(button);
    }

    protected void mouseClicked(int par1, int par2, int par3) throws IOException {
        if (this.getActivePage() == null) {
            return;
        }
        this.getActivePage().func_73864_a(par1, par2, par3);
    }
}

