/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual.pages;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import techreborn.manual.PageCollection;
import techreborn.manual.pages.TitledPage;
import techreborn.manual.util.ButtonUtil;

public class DescriptionPage
extends TitledPage {
    public boolean hasImage;
    public String secondpage;
    private String rawDescription;
    private List<String> formattedDescription;
    private float descriptionScale = 0.88f;
    public String imageprefix = "techreborn:textures/manual/screenshots/";

    public DescriptionPage(String name, PageCollection collection, boolean hasImage, String secondPage) {
        super(name, false, collection, "techreborn.manual.gettingstarted", Color.white.getRGB());
        this.hasImage = hasImage;
        this.rawDescription = "techreborn.manual." + this.getReferenceName() + ".description";
        this.secondpage = secondPage;
    }

    @Override
    public void renderOverlayComponents(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.hasImage) {
            this.renderImage(offsetX, offsetY);
            this.addDescription(this.field_146297_k, offsetX, offsetY + 60);
        } else {
            this.addDescription(this.field_146297_k, offsetX, offsetY);
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        ButtonUtil.addBackButton(0, this.field_146294_l / 2 - 60, this.field_146295_m / 2 + 64, this.field_146292_n);
        if (this.secondpage != null) {
            ButtonUtil.addNextButton(1, this.field_146294_l / 2 + 40, this.field_146295_m / 2 + 64, this.field_146292_n);
        }
    }

    public void renderImage(int offsetX, int offsetY) {
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(new ResourceLocation(this.imageprefix + this.getReferenceName() + ".png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(offsetX, offsetY - 14, 0, 0, 120, this.field_146295_m);
        GL11.glDisable((int)3042);
    }

    public void addDescription(Minecraft minecraft, int offsetX, int offsetY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + 15), (double)(offsetY + 40), (double)1.0);
        GL11.glScalef((float)this.descriptionScale, (float)this.descriptionScale, (float)this.descriptionScale);
        int offset = 0;
        for (String s : this.getFormattedText(this.field_146289_q)) {
            if (s == null) break;
            if (s.contains("\\%") && s.substring(0, 2).equals("\\%")) {
                s = s.substring(2);
                offset += this.field_146289_q.field_78288_b / 2;
            }
            this.field_146289_q.func_78276_b(s, 0, offset, Color.black.getRGB());
            offset += this.field_146289_q.field_78288_b;
        }
        GL11.glPopMatrix();
    }

    public List<String> getFormattedText(FontRenderer fr) {
        if (this.formattedDescription == null) {
            this.formattedDescription = new ArrayList<String>();
            if (Strings.isNullOrEmpty((String)this.rawDescription)) {
                this.formattedDescription = ImmutableList.of();
                return this.formattedDescription;
            }
            if (!this.rawDescription.contains("\\n")) {
                this.formattedDescription = ImmutableList.copyOf((Collection)fr.func_78271_c(this.rawDescription, 130));
                return this.formattedDescription;
            }
            ArrayList segments = new ArrayList();
            String raw = this.rawDescription;
            for (String s : segments) {
                this.formattedDescription.addAll((Collection<String>)ImmutableList.copyOf((Collection)fr.func_78271_c(s, 370)));
            }
        }
        return this.formattedDescription;
    }

    @Override
    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.collection.changeActivePage("gettingstarted");
        }
        if (this.secondpage != null && button.field_146127_k == 1) {
            this.collection.changeActivePage(this.secondpage);
        }
    }
}

