/*
 * Decompiled with CFR 0.152.
 */
package techreborn.power;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import reborncore.api.power.IEnergyInterfaceTile;
import techreborn.parts.CableMultipart;
import techreborn.parts.EnumCableType;
import techreborn.power.PowerTickEvent;

public class TRPowerNet {
    int tick = 0;
    private ArrayList<CableMultipart> cables = new ArrayList();
    public ArrayList<EnergyHandler> endpoints = new ArrayList();
    private int energy = 0;
    EnumCableType cableType;

    public TRPowerNet(EnumCableType cableType) {
        this.cableType = cableType;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int getIOLimit() {
        return this.cableType.transferRate;
    }

    @SubscribeEvent
    public void tick(PowerTickEvent evt) {
        if (this.tick < 20) {
            ++this.tick;
            return;
        }
        if (this.tick % 80 == 0) {
            ArrayList<CableMultipart> oldCables = new ArrayList<CableMultipart>();
            for (CableMultipart cableMultipart : this.cables) {
                CableMultipart mp;
                if (cableMultipart.getWorld() == null || cableMultipart.getPos() == null) {
                    oldCables.add(cableMultipart);
                }
                if ((mp = cableMultipart.getPartFromWorld(cableMultipart.getWorld(), cableMultipart.getPos(), null)) != null) continue;
                oldCables.add(cableMultipart);
            }
            this.cables.removeAll(oldCables);
        }
        if (!this.cables.isEmpty()) {
            ArrayList<EnergyHandler> collectibles = new ArrayList<EnergyHandler>();
            ArrayList<EnergyHandler> insertibles = new ArrayList<EnergyHandler>();
            for (int i = 0; i < this.endpoints.size(); ++i) {
                EnergyHandler ei = this.endpoints.get(i);
                if (ei.isCollectible()) {
                    collectibles.add(ei);
                }
                if (!ei.isInsertible()) continue;
                insertibles.add(ei);
            }
            for (EnergyHandler handler : collectibles) {
                this.energy += handler.collectEnergy(this.cableType.transferRate);
            }
            for (EnergyHandler handler : insertibles) {
                this.energy -= handler.addEnergy(Math.min(this.energy, this.cableType.transferRate));
            }
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
        ++this.tick;
    }

    public void addElement(CableMultipart te) {
        if (!this.cables.contains(te)) {
            this.cables.add(te);
        }
    }

    public void removeElement(CableMultipart te) {
        this.cables.remove(te);
        this.rebuild();
    }

    private void rebuild() {
        for (int i = 0; i < this.cables.size(); ++i) {
            CableMultipart te = this.cables.get(i);
            te.setNetwork(null);
            te.findAndJoinNetwork(te.getWorld(), te.getPos());
        }
        this.clear(true);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public void addConnection(IEnergyInterfaceTile ih, EnumFacing dir) {
        if (ih instanceof CableMultipart) {
            return;
        }
        EnergyHandler has = this.getHandleFrom(ih);
        if (has == null) {
            this.endpoints.add(new EnergyHandler(ih, this.cableType, dir));
        } else {
            has.side = dir;
        }
    }

    public void merge(TRPowerNet n) {
        if (n != this) {
            CableMultipart wire;
            int i;
            ArrayList<CableMultipart> li = new ArrayList<CableMultipart>();
            for (i = 0; i < n.cables.size(); ++i) {
                wire = n.cables.get(i);
                li.add(wire);
            }
            for (i = 0; i < n.endpoints.size(); ++i) {
                EnergyHandler ei = n.endpoints.get(i);
                EnergyHandler has = this.getHandleFrom(ei.tile);
                if (has != null) continue;
                this.endpoints.add(ei);
            }
            n.clear(false);
            for (i = 0; i < li.size(); ++i) {
                wire = (CableMultipart)li.get(i);
                wire.setNetwork(this);
            }
            MinecraftForge.EVENT_BUS.unregister((Object)n);
        }
    }

    private EnergyHandler getHandleFrom(IEnergyInterfaceTile tile) {
        for (int i = 0; i < this.endpoints.size(); ++i) {
            EnergyHandler ei = this.endpoints.get(i);
            if (!ei.contains(tile)) continue;
            return ei;
        }
        return null;
    }

    private void clear(boolean clearTiles) {
        if (clearTiles) {
            for (int i = 0; i < this.cables.size(); ++i) {
                this.cables.get(i).resetNetwork();
            }
        }
        this.cables.clear();
        this.endpoints.clear();
        this.energy = 0;
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public String toString() {
        return this.cables.size() + ": " + this.endpoints.toString();
    }

    public int addEnergy(int maxAdd, boolean simulate) {
        if (this.energy >= this.getIOLimit()) {
            return 0;
        }
        maxAdd = Math.min(this.getIOLimit(), maxAdd);
        if (!simulate) {
            this.energy += maxAdd;
        }
        return maxAdd;
    }

    private static class EnergyHandler {
        private final IEnergyInterfaceTile tile;
        private EnumFacing side;
        private final EnumCableType type;

        private EnergyHandler(IEnergyInterfaceTile ih, EnumCableType type, EnumFacing dir) {
            this.tile = ih;
            this.type = type;
            this.side = dir;
        }

        public boolean isInsertible() {
            return this.getTotalInsertible() > 0;
        }

        public boolean isCollectible() {
            return this.getTotalCollectible() > 0;
        }

        public boolean contains(IEnergyInterfaceTile tile) {
            return tile == this.tile;
        }

        public int collectEnergy(int max) {
            int total = 0;
            if (this.tile.canProvideEnergy(EnumFacing.NORTH)) {
                int collect = (int)Math.min((double)max, this.tile.getMaxOutput());
                total = (int)this.tile.useEnergy((double)collect, false);
            }
            return total;
        }

        public int addEnergy(int max) {
            int total = 0;
            if (this.tile.canAcceptEnergy(EnumFacing.NORTH) && max > 0) {
                if (this.type.tier.ordinal() > this.tile.getTier().ordinal()) {
                    if (this.tile instanceof TileEntity) {
                        ((TileEntity)this.tile).func_145831_w().func_72876_a((Entity)new EntityTNTPrimed(((TileEntity)this.tile).func_145831_w()), (double)((TileEntity)this.tile).func_174877_v().func_177958_n(), (double)((TileEntity)this.tile).func_174877_v().func_177956_o(), (double)((TileEntity)this.tile).func_174877_v().func_177952_p(), 2.5f, true);
                    }
                    return 0;
                }
                int add = max - total;
                total = (int)((double)total + this.tile.addEnergy((double)add, false));
            }
            return total;
        }

        public int getTotalCollectible() {
            if (this.tile.canProvideEnergy(EnumFacing.NORTH)) {
                return (int)Math.min(this.tile.getMaxOutput(), this.tile.getEnergy());
            }
            return 0;
        }

        public int getTotalInsertible() {
            int total = 0;
            if (this.tile.canAcceptEnergy(EnumFacing.NORTH)) {
                total = (int)((double)total + this.tile.addEnergy((double)this.type.transferRate, true));
            }
            return total;
        }

        public String toString() {
            return this.tile + " @ " + this.side;
        }
    }
}

