/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.recipe.IBaseRecipeType;
import techreborn.api.recipe.RecipeHandler;
import techreborn.init.ModBlocks;
import techreborn.lib.Reference;

public class TileAlloyFurnace
extends TileMachineBase
implements IWrenchable,
IInventory {
    public int tickTime;
    public Inventory inventory = new Inventory(4, "TileAlloyFurnace", 64, (TileEntity)this);
    int input1 = 0;
    int input2 = 1;
    int output = 2;
    int fuel = 3;
    public int burnTime;
    public int currentItemBurnTime;
    public int cookTime;

    public void updateEntity() {
        super.updateEntity();
        boolean flag = this.burnTime > 0;
        boolean flag1 = false;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime != 0 || this.func_70301_a(this.input1) != null && this.func_70301_a(this.fuel) != null) {
                if (this.burnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.burnTime = TileAlloyFurnace.getItemBurnTime(this.func_70301_a(this.fuel));
                    if (this.burnTime > 0) {
                        flag1 = true;
                        if (this.func_70301_a(this.fuel) != null) {
                            this.func_70298_a(this.fuel, 1);
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == 200) {
                        this.cookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (flag != this.burnTime > 0) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean hasAllInputs(IBaseRecipeType recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (ItemStack input : recipeType.getInputs()) {
            Boolean hasItem = false;
            for (int inputslot = 0; inputslot < 2; ++inputslot) {
                if (!ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.inventory.func_70301_a(inputslot), (boolean)true, (boolean)true, (boolean)recipeType.useOreDic()) || this.inventory.func_70301_a((int)inputslot).field_77994_a < input.field_77994_a) continue;
                hasItem = true;
            }
            if (hasItem.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean canSmelt() {
        if (this.func_70301_a(this.input1) == null || this.func_70301_a(this.input2) == null) {
            return false;
        }
        ItemStack itemstack = null;
        for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName(Reference.alloySmelteRecipe)) {
            if (!this.hasAllInputs(recipeType)) continue;
            itemstack = recipeType.getOutput(0);
            break;
        }
        if (itemstack == null) {
            return false;
        }
        if (this.func_70301_a(this.output) == null) {
            return true;
        }
        if (!this.func_70301_a(this.output).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.func_70301_a((int)this.output).field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.func_70301_a(this.output).func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = null;
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName(Reference.alloySmelteRecipe)) {
                for (ItemStack input : recipeType.getInputs()) {
                    if (!ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.func_70301_a(this.input1), (boolean)true, (boolean)true, (boolean)true) && !ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.func_70301_a(this.input2), (boolean)true, (boolean)true, (boolean)true)) continue;
                    itemstack = recipeType.getOutput(0);
                    break;
                }
                if (itemstack == null) continue;
                break;
            }
            if (this.func_70301_a(this.output) == null) {
                this.func_70299_a(this.output, itemstack.func_77946_l());
            } else if (this.func_70301_a(this.output).func_77973_b() == itemstack.func_77973_b()) {
                this.func_70298_a(this.output, -itemstack.field_77994_a);
            }
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName(Reference.alloySmelteRecipe)) {
                boolean hasAllRecipes = true;
                for (ItemStack input : recipeType.getInputs()) {
                    if (ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.func_70301_a(this.input1), (boolean)true, (boolean)true, (boolean)true) || ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.func_70301_a(this.input2), (boolean)true, (boolean)true, (boolean)true)) continue;
                    hasAllRecipes = false;
                }
                if (!hasAllRecipes) continue;
                block4: for (ItemStack input : recipeType.getInputs()) {
                    for (int inputSlot = 0; inputSlot < 2; ++inputSlot) {
                        if (!ItemUtils.isItemEqual((ItemStack)input, (ItemStack)this.inventory.func_70301_a(inputSlot), (boolean)true, (boolean)true, (boolean)recipeType.useOreDic())) continue;
                        this.inventory.func_70298_a(inputSlot, input.field_77994_a);
                        continue block4;
                    }
                }
            }
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTime * scale / this.currentItemBurnTime;
    }

    public int getCookProgressScaled(int scale) {
        return this.cookTime * scale / 200;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.AlloyFurnace, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }
}

