/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.misc.Location;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.recipe.RecipeCrafter;
import techreborn.blocks.BlockMachineCasing;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.lib.Reference;
import techreborn.multiblocks.MultiBlockCasing;
import techreborn.tiles.TileMachineCasing;

public class TileBlastFurnace
extends TilePowerAcceptor
implements IWrenchable,
IInventory,
ISidedInventory {
    public int tickTime;
    public Inventory inventory = new Inventory(4, "TileBlastFurnace", 64, (TileEntity)this);
    public RecipeCrafter crafter;
    public int capacity = 1000;
    public static int euTick = 5;

    public TileBlastFurnace() {
        super(ConfigTechReborn.CentrifugeTier);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3};
        this.crafter = new RecipeCrafter(Reference.blastFurnaceRecipe, (TileMachineBase)this, 2, 2, this.inventory, inputs, outputs);
    }

    public void updateEntity() {
        super.updateEntity();
        this.crafter.updateEntity();
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.BlastFurnace, 1);
    }

    public int getHeat() {
        for (EnumFacing direction : EnumFacing.values()) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + direction.func_82601_c(), this.func_174877_v().func_177956_o() + direction.func_96559_d(), this.func_174877_v().func_177952_p() + direction.func_82599_e()));
            if (!(tileEntity instanceof TileMachineCasing) || !((TileMachineCasing)tileEntity).isConnected() || !((TileMachineCasing)tileEntity).getMultiblockController().isAssembled()) continue;
            MultiBlockCasing casing = ((TileMachineCasing)tileEntity).getMultiblockController();
            Location location = new Location(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), direction);
            location.modifyPositionFromSide(direction, 1);
            int heat = 0;
            if (this.field_145850_b.func_180495_p(new BlockPos(location.getX(), location.getY() - 1, location.getZ())).func_177230_c() == tileEntity.func_145838_q()) {
                return 0;
            }
            for (IMultiblockPart part : casing.connectedParts) {
                BlockMachineCasing casing1 = (BlockMachineCasing)this.field_145850_b.func_180495_p(part.func_174877_v()).func_177230_c();
                heat += casing1.getHeatFromState(part.func_145831_w().func_180495_p(part.getWorldLocation().toBlockPos()));
            }
            if (this.field_145850_b.func_180495_p(new BlockPos(location.getX(), location.getY(), location.getZ())).func_177230_c().func_149739_a().equals("tile.lava") && this.field_145850_b.func_180495_p(new BlockPos(location.getX(), location.getY() + 1, location.getZ())).func_177230_c().func_149739_a().equals("tile.lava")) {
                heat += 500;
            }
            return heat;
        }
        return 0;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.inventory.func_70301_a(p_70301_1_);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return this.inventory.func_70298_a(p_70298_1_, p_70298_2_);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return this.inventory.func_70304_b(p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.inventory.func_70299_a(p_70299_1_, p_70299_2_);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.inventory.func_70300_a(p_70300_1_);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return this.inventory.func_94041_b(p_94041_1_, p_94041_2_);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        this.tickTime = tagCompound.func_74762_e("tickTime");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        this.writeUpdateToNBT(tagCompound);
    }

    public void writeUpdateToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("tickTime", this.tickTime);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray = nArray2;
            nArray2[3] = 3;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray = nArray3;
            nArray3[3] = 3;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex >= 2) {
            return false;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2 || slotIndex == 3;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 128.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.HIGH;
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }
}

