/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.IEnergyInterfaceItem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

public class TileChargeBench
extends TilePowerAcceptor
implements IWrenchable,
IInventory,
ISidedInventory {
    public Inventory inventory = new Inventory(6, "TileChargeBench", 64, (TileEntity)this);
    public int capacity = 100000;

    public TileChargeBench() {
        super(4);
    }

    public void updateEntity() {
        super.updateEntity();
        for (int i = 0; i < 6; ++i) {
            ItemStack stack;
            if (this.inventory.func_70301_a(i) == null || !(this.getEnergy() > 0.0) || !((stack = this.inventory.func_70301_a(i)).func_77973_b() instanceof IEnergyInterfaceItem)) continue;
            IEnergyInterfaceItem interfaceItem = (IEnergyInterfaceItem)stack.func_77973_b();
            double trans = Math.min(interfaceItem.getMaxPower(stack) - interfaceItem.getEnergy(stack), Math.min(interfaceItem.getMaxTransfer(stack), this.getEnergy()));
            interfaceItem.setEnergy(trans + interfaceItem.getEnergy(stack), stack);
            this.useEnergy(trans);
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.chargeBench, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray = nArray2;
            nArray2[5] = 5;
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArray3[4] = 4;
            nArray = nArray3;
            nArray3[5] = 5;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return false;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 512.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.MEDIUM;
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }
}

