/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;

public class TileIronFurnace
extends TileMachineBase
implements IInventory {
    public int tickTime;
    public Inventory inventory = new Inventory(3, "TileIronFurnace", 64, (TileEntity)this);
    int input1 = 0;
    int output = 1;
    int fuelslot = 2;
    boolean active = false;
    public int fuel;
    public int fuelGague;
    public int progress;
    public int fuelScale = 200;

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.fuelScale;
    }

    public int gaugeFuelScaled(int scale) {
        if (this.fuelGague == 0) {
            this.fuelGague = this.fuel;
            if (this.fuelGague == 0) {
                this.fuelGague = this.fuelScale;
            }
        }
        return this.fuel * scale / this.fuelGague;
    }

    public void updateEntity() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.fuel > 0) {
            --this.fuel;
            this.updateState();
        }
        if (this.fuel <= 0 && this.canSmelt()) {
            this.fuel = this.fuelGague = TileIronFurnace.getItemBurnTime(this.func_70301_a(this.fuelslot));
            if (this.fuel > 0) {
                if (this.func_70301_a(this.fuelslot).func_77973_b().func_77634_r()) {
                    this.func_70299_a(this.fuelslot, new ItemStack(this.func_70301_a(this.fuelslot).func_77973_b().func_77668_q()));
                } else if (this.func_70301_a((int)this.fuelslot).field_77994_a > 1) {
                    this.func_70298_a(this.fuelslot, 1);
                } else if (this.func_70301_a((int)this.fuelslot).field_77994_a == 1) {
                    this.func_70299_a(this.fuelslot, null);
                }
                updateInventory = true;
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.progress;
            if (this.progress >= this.fuelScale) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
            if (this.func_70301_a(this.output) == null) {
                this.func_70299_a(this.output, itemstack.func_77946_l());
            } else if (this.func_70301_a(this.output).func_77969_a(itemstack)) {
                this.func_70301_a((int)this.output).field_77994_a += itemstack.field_77994_a;
            }
            if (this.func_70301_a((int)this.input1).field_77994_a > 1) {
                this.func_70298_a(this.input1, 1);
            } else {
                this.func_70299_a(this.input1, null);
            }
        }
    }

    public boolean canSmelt() {
        if (this.func_70301_a(this.input1) == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
        if (itemstack == null) {
            return false;
        }
        if (this.func_70301_a(this.output) == null) {
            return true;
        }
        if (!this.func_70301_a(this.output).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.func_70301_a((int)this.output).field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        if (result != null) {
            return result.func_77946_l();
        }
        return null;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)item) != null) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block == Blocks.field_150364_r) {
                return 1200;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == new ItemStack(Blocks.field_150345_g).func_77973_b()) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public void updateState() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (blockState.func_177230_c() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)blockState.func_177230_c();
            if ((Boolean)blockState.func_177229_b((IProperty)BlockMachineBase.ACTIVE) != this.fuel > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.fuel > 0), this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }
}

