/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;

public class TileMatterFabricator
extends TilePowerAcceptor
implements IWrenchable,
IInventory,
ISidedInventory {
    public static int fabricationRate = 2666656;
    public int tickTime;
    public Inventory inventory = new Inventory(7, "TileMatterFabricator", 64, (TileEntity)this);
    private int amplifier = 0;
    public int progresstime = 0;

    public TileMatterFabricator() {
        super(6);
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.MatterFabricator, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[7];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray2[5] = 5;
            nArray = nArray2;
            nArray2[6] = 6;
        } else {
            int[] nArray3 = new int[7];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArray3[4] = 4;
            nArray3[5] = 5;
            nArray = nArray3;
            nArray3[6] = 6;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex == 6) {
            return false;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 6;
    }

    public int maxProgresstime() {
        return fabricationRate;
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (this.amplifier >= 100000 || stack == null) continue;
                int amp = (int)((long)(this.getValue(stack) / 32));
                if (!ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)this.inventory.func_70301_a(i), (boolean)true, (boolean)true) || !this.canUseEnergy(1.0)) continue;
                this.useEnergy(1.0);
                this.amplifier += amp;
                this.inventory.func_70298_a(i, 1);
            }
            if (this.amplifier > 0) {
                if ((double)this.amplifier > this.getEnergy()) {
                    this.progresstime = (int)((double)this.progresstime + this.getEnergy());
                    this.amplifier = (int)((double)this.amplifier - this.getEnergy());
                    this.decreaseStoredEnergy(this.getEnergy(), true);
                } else {
                    this.progresstime += this.amplifier;
                    this.decreaseStoredEnergy(this.amplifier, true);
                    this.amplifier = 0;
                }
            }
            if (this.progresstime > this.maxProgresstime() && this.spaceForOutput()) {
                this.progresstime -= this.maxProgresstime();
                this.addOutputProducts();
            }
        }
    }

    private boolean spaceForOutput() {
        return this.inventory.func_70301_a(6) == null || ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(6), (ItemStack)new ItemStack(ModItems.uuMatter), (boolean)true, (boolean)true) && this.inventory.func_70301_a((int)6).field_77994_a < 64;
    }

    private void addOutputProducts() {
        if (this.inventory.func_70301_a(6) == null) {
            this.inventory.func_70299_a(6, new ItemStack(ModItems.uuMatter));
        } else if (ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(6), (ItemStack)new ItemStack(ModItems.uuMatter), (boolean)true, (boolean)true)) {
            this.inventory.func_70301_a((int)6).field_77994_a = Math.min(64, 1 + this.inventory.func_70301_a((int)6).field_77994_a);
        }
    }

    public boolean decreaseStoredEnergy(double aEnergy, boolean aIgnoreTooLessEnergy) {
        if (this.getEnergy() - aEnergy < 0.0 && !aIgnoreTooLessEnergy) {
            return false;
        }
        this.setEnergy(this.getEnergy() - aEnergy);
        if (this.getEnergy() < 0.0) {
            this.setEnergy(0.0);
            return false;
        }
        return true;
    }

    public int getValue(ItemStack itemStack) {
        int value = TileMatterFabricator.getValue(Recipes.matterAmplifier.getOutputFor(itemStack, false));
        return value;
    }

    private static Integer getValue(RecipeOutput output) {
        if (output != null && output.metadata != null) {
            return output.metadata.func_74762_e("amplification");
        }
        return 0;
    }

    public double getMaxPower() {
        return 1.0E8;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 4096.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.EXTREME;
    }
}

