/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import reborncore.api.IListInfoProvider;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.init.ModBlocks;

public class TileQuantumTank
extends TileMachineBase
implements IFluidHandler,
IInventory,
IWrenchable,
IListInfoProvider {
    public Tank tank = new Tank("TileQuantumTank", Integer.MAX_VALUE, (TileEntity)this);
    public Inventory inventory = new Inventory(3, "TileQuantumTank", 64, (TileEntity)this);

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readFromNBTWithoutCoords(tagCompound);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.readFromNBT(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.writeToNBTWithoutCoords(tagCompound);
    }

    public void writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.writeToNBT(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        this.func_145839_a(packet.func_148857_g());
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            FluidUtils.drainContainers((IFluidHandler)this, (IInventory)this.inventory, (int)0, (int)1);
            FluidUtils.fillContainers((IFluidHandler)this, (IInventory)this.inventory, (int)0, (int)1, (Fluid)this.tank.getFluidType());
            if (this.tank.getFluidType() != null && this.func_70301_a(2) == null) {
                this.inventory.func_70299_a(2, new ItemStack(this.tank.getFluidType().getBlock()));
            } else if (this.tank.getFluidType() == null && this.func_70301_a(2) != null) {
                this.func_70299_a(2, null);
            }
            this.tank.compareAndUpdate();
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int fill = this.tank.fill(resource, doFill);
        this.tank.compareAndUpdate();
        return fill;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        FluidStack drain = this.tank.drain(resource.amount, doDrain);
        this.tank.compareAndUpdate();
        return drain;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidStack drain = this.tank.drain(maxDrain, doDrain);
        this.tank.compareAndUpdate();
        return drain;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        ItemStack stack = this.inventory.func_70298_a(slotId, count);
        this.syncWithAll();
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
        this.syncWithAll();
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(ModBlocks.quantumTank, 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.func_77978_p().func_74782_a("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        if (isRealTile) {
            if (this.tank.getFluid() != null) {
                info.add(this.tank.getFluidAmount() + " of " + this.tank.getFluidType().getName());
            } else {
                info.add("Empty");
            }
        }
        info.add("Capacity " + this.tank.getCapacity() + " mb");
    }
}

