/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.RollingMachineRecipe;
import techreborn.init.ModBlocks;

public class TileRollingMachine
extends TilePowerAcceptor
implements IWrenchable,
IInventory {
    public Inventory inventory = new Inventory(3, "TileRollingMachine", 64, (TileEntity)this);
    public final InventoryCrafting craftMatrix = new InventoryCrafting((Container)new RollingTileContainer(), 3, 3);
    public boolean isRunning;
    public int tickTime;
    public int runTime = 250;
    public ItemStack currentRecipe;
    public int euTick = 5;

    public double getMaxPower() {
        return 100000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 64.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public TileRollingMachine() {
        super(1);
    }

    public void updateEntity() {
        super.updateEntity();
        this.charge(2);
        if (!this.field_145850_b.field_72995_K) {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
            if (this.currentRecipe != null && this.canMake() && this.tickTime >= this.runTime) {
                this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
                if (this.currentRecipe != null) {
                    boolean hasCrafted = false;
                    if (this.inventory.func_70301_a(0) == null) {
                        this.inventory.func_70299_a(0, this.currentRecipe);
                        this.tickTime = -1;
                        hasCrafted = true;
                    } else if (this.inventory.func_70301_a((int)0).field_77994_a + this.currentRecipe.field_77994_a <= this.currentRecipe.func_77976_d()) {
                        ItemStack stack = this.inventory.func_70301_a(0);
                        stack.field_77994_a += this.currentRecipe.field_77994_a;
                        this.inventory.func_70299_a(0, stack);
                        this.tickTime = -1;
                        hasCrafted = true;
                    }
                    if (hasCrafted) {
                        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                            this.craftMatrix.func_70298_a(i, 1);
                        }
                        this.currentRecipe = null;
                    }
                }
            }
            if (this.currentRecipe != null && this.canUseEnergy(this.euTick) && this.tickTime < this.runTime) {
                this.useEnergy(this.euTick);
                ++this.tickTime;
            }
            if (this.currentRecipe == null) {
                this.tickTime = -1;
            }
        } else {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
            if (this.currentRecipe != null) {
                this.inventory.func_70299_a(1, this.currentRecipe);
            } else {
                this.inventory.func_70299_a(1, null);
            }
        }
    }

    public boolean canMake() {
        return RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b) != null;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.RollingMachine, 1);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        ItemUtils.readInvFromNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.isRunning = tagCompound.func_74767_n("isRunning");
        this.tickTime = tagCompound.func_74762_e("tickTime");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        ItemUtils.writeInvToNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.writeUpdateToNBT(tagCompound);
    }

    public void writeUpdateToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("isRunning", this.isRunning);
        tagCompound.func_74768_a("tickTime", this.tickTime);
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    private static class RollingTileContainer
    extends Container {
        private RollingTileContainer() {
        }

        public boolean func_75145_c(EntityPlayer entityplayer) {
            return true;
        }
    }
}

