/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.api.ScrapboxList;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;

public class TileScrapboxinator
extends TilePowerAcceptor
implements IWrenchable,
IInventory,
ISidedInventory {
    public Inventory inventory = new Inventory(6, "TileScrapboxinator", 64, (TileEntity)this);
    public int capacity = 1000;
    public int cost = 20;
    public int progress;
    public int time = 200;
    public int chance = 4;
    public int random;
    public int input1 = 0;
    public int output = 1;

    public TileScrapboxinator() {
        super(1);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.time;
    }

    public void updateEntity() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.getEnergy() <= (double)this.cost && this.canOpen() && this.getEnergy() > (double)this.cost) {
            updateInventory = true;
        }
        if (this.isBurning() && this.canOpen()) {
            this.updateState();
            ++this.progress;
            if (this.progress >= this.time) {
                this.progress = 0;
                this.recycleItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
            this.updateState();
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public void recycleItems() {
        if (this.canOpen() && !this.field_145850_b.field_72995_K) {
            int random = new Random().nextInt(ScrapboxList.stacks.size());
            ItemStack out = ScrapboxList.stacks.get(random).func_77946_l();
            if (this.func_70301_a(this.output) == null) {
                this.useEnergy(this.cost);
                this.func_70299_a(this.output, out);
            }
            if (this.func_70301_a((int)this.input1).field_77994_a > 1) {
                this.useEnergy(this.cost);
                this.func_70298_a(this.input1, 1);
            } else {
                this.useEnergy(this.cost);
                this.func_70299_a(this.input1, null);
            }
        }
    }

    public boolean canOpen() {
        return this.func_70301_a(this.input1) != null && this.func_70301_a(this.output) == null;
    }

    public boolean isBurning() {
        return this.getEnergy() > (double)this.cost;
    }

    public void updateState() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (blockState.func_177230_c() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)blockState.func_177230_c();
            if ((Boolean)blockState.func_177229_b((IProperty)BlockMachineBase.ACTIVE) != this.progress > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.progress > 0), this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.scrapboxinator, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex == 2) {
            return false;
        }
        if (slotIndex == 1 && itemStack.func_77973_b() == ModItems.scrapBox) {
            return true;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.MEDIUM;
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }
}

