/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.recipe.RecipeCrafter;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;
import techreborn.lib.Reference;

public class TileVacuumFreezer
extends TilePowerAcceptor
implements IWrenchable,
IInventory {
    public int tickTime;
    public Inventory inventory = new Inventory(3, "TileVacuumFreezer", 64, (TileEntity)this);
    public RecipeCrafter crafter;
    public int multiBlockStatus = 0;

    public TileVacuumFreezer() {
        super(2);
        int[] inputs = new int[]{0};
        int[] outputs = new int[]{1};
        this.crafter = new RecipeCrafter(Reference.vacuumFreezerRecipe, (TileMachineBase)this, 2, 1, this.inventory, inputs, outputs);
    }

    public void updateEntity() {
        super.updateEntity();
        this.crafter.updateEntity();
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.multiBlockStatus = this.checkMachine() ? 1 : 0;
        }
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 128.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.MEDIUM;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.AlloySmelter, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        this.crafter.writeToNBT(tagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public boolean checkMachine() {
        int xDir = EnumFacing.UP.func_82601_c() * 2;
        int yDir = EnumFacing.UP.func_96559_d() * 2;
        int zDir = EnumFacing.UP.func_82599_e() * 2;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (i != 0 || j != 0 || k != 0) {
                        if (this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() - xDir + i, this.func_174877_v().func_177956_o() - yDir + j, this.func_174877_v().func_177952_p() - zDir + k)).func_177230_c() != ModBlocks.MachineCasing) {
                            return false;
                        }
                        IBlockState blockState = this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() - xDir + i, this.func_174877_v().func_177956_o() - yDir + j, this.func_174877_v().func_177952_p() - zDir + k));
                        BlockMachineCasing blockMachineCasing = (BlockMachineCasing)blockState.func_177230_c();
                        if (blockMachineCasing.func_176201_c(blockState) == (i == 0 && j == 0 && k != 0 || i == 0 && j != 0 && k == 0 || i != 0 && j == 0 && k == 0 ? 2 : 1)) continue;
                        return false;
                    }
                    if (this.field_145850_b.func_175623_d(new BlockPos(this.func_174877_v().func_177958_n() - xDir + i, this.func_174877_v().func_177956_o() - yDir + j, this.func_174877_v().func_177952_p() - zDir + k))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

