/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.fusionReactor;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.init.ModBlocks;

public class TileEntityFusionController
extends TilePowerAcceptor
implements IInventory {
    public Inventory inventory = new Inventory(3, "TileEntityFusionController", 64, (TileEntity)this);
    public int coilStatus = 0;
    int topStackSlot = 0;
    int bottomStackSlot = 1;
    int outputStackSlot = 2;
    public int crafingTickTime = 0;
    public int finalTickTime = 0;
    public int neededPower = 0;
    FusionReactorRecipe currentRecipe = null;
    boolean hasStartedCrafting = false;

    public TileEntityFusionController() {
        super(4);
    }

    public double getMaxPower() {
        return 1.0E8;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return direction != EnumFacing.DOWN && direction != EnumFacing.UP;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return direction == EnumFacing.DOWN || direction == EnumFacing.UP;
    }

    public double getMaxOutput() {
        if (!this.hasStartedCrafting) {
            return 0.0;
        }
        return 1000000.0;
    }

    public double getMaxInput() {
        if (this.hasStartedCrafting) {
            return 0.0;
        }
        return 8192.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.EXTREME;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        this.crafingTickTime = tagCompound.func_74762_e("crafingTickTime");
        this.finalTickTime = tagCompound.func_74762_e("finalTickTime");
        this.neededPower = tagCompound.func_74762_e("neededPower");
        this.hasStartedCrafting = tagCompound.func_74767_n("hasStartedCrafting");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        if (this.crafingTickTime == -1) {
            this.crafingTickTime = 0;
        }
        if (this.finalTickTime == -1) {
            this.finalTickTime = 0;
        }
        if (this.neededPower == -1) {
            this.neededPower = 0;
        }
        tagCompound.func_74768_a("crafingTickTime", this.crafingTickTime);
        tagCompound.func_74768_a("finalTickTime", this.finalTickTime);
        tagCompound.func_74768_a("neededPower", this.neededPower);
        tagCompound.func_74757_a("hasStartedCrafting", this.hasStartedCrafting);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public boolean checkCoils() {
        if (this.isCoil(this.func_174877_v().func_177958_n() + 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 1) && this.isCoil(this.func_174877_v().func_177958_n() + 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()) && this.isCoil(this.func_174877_v().func_177958_n() + 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 1) && this.isCoil(this.func_174877_v().func_177958_n() - 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 1) && this.isCoil(this.func_174877_v().func_177958_n() - 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()) && this.isCoil(this.func_174877_v().func_177958_n() - 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 1) && this.isCoil(this.func_174877_v().func_177958_n() + 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 2) && this.isCoil(this.func_174877_v().func_177958_n() + 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 1) && this.isCoil(this.func_174877_v().func_177958_n() + 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 1) && this.isCoil(this.func_174877_v().func_177958_n() + 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 2) && this.isCoil(this.func_174877_v().func_177958_n() - 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 2) && this.isCoil(this.func_174877_v().func_177958_n() - 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 1) && this.isCoil(this.func_174877_v().func_177958_n() - 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 1) && this.isCoil(this.func_174877_v().func_177958_n() - 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 2) && this.isCoil(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 3) && this.isCoil(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 2) && this.isCoil(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 2) && this.isCoil(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 3) && this.isCoil(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 3) && this.isCoil(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 2) && this.isCoil(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 2) && this.isCoil(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 3) && this.isCoil(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 3) && this.isCoil(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 3)) {
            this.coilStatus = 1;
            return true;
        }
        this.coilStatus = 0;
        return false;
    }

    private boolean isCoil(int x, int y, int z) {
        return this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == ModBlocks.FusionCoil;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.checkCoils();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.coilStatus == 1) {
                if (this.currentRecipe == null) {
                    if (this.inventory.hasChanged || this.crafingTickTime != 0) {
                        for (FusionReactorRecipe reactorRecipe : FusionReactorRecipeHelper.reactorRecipes) {
                            if (!ItemUtils.isItemEqual((ItemStack)this.func_70301_a(this.topStackSlot), (ItemStack)reactorRecipe.getTopInput(), (boolean)true, (boolean)true, (boolean)true)) continue;
                            if (reactorRecipe.getBottomInput() == null || ItemUtils.isItemEqual((ItemStack)this.func_70301_a(this.bottomStackSlot), (ItemStack)reactorRecipe.getBottomInput(), (boolean)true, (boolean)true, (boolean)true)) {
                                if (!this.canFitStack(reactorRecipe.getOutput(), this.outputStackSlot, true)) continue;
                                this.currentRecipe = reactorRecipe;
                                if (this.crafingTickTime != 0) {
                                    this.finalTickTime = this.currentRecipe.getTickTime();
                                    this.neededPower = (int)this.currentRecipe.getStartEU();
                                }
                                this.hasStartedCrafting = false;
                                this.crafingTickTime = 0;
                                this.finalTickTime = this.currentRecipe.getTickTime();
                                this.neededPower = (int)this.currentRecipe.getStartEU();
                            }
                            break;
                        }
                    }
                } else {
                    if (this.inventory.hasChanged && !this.validateRecipe()) {
                        this.resetCrafter();
                        return;
                    }
                    if (!this.hasStartedCrafting) {
                        if (this.canUseEnergy(this.currentRecipe.getStartEU() + 64.0)) {
                            this.useEnergy(this.currentRecipe.getStartEU());
                            this.hasStartedCrafting = true;
                        }
                    } else if (this.crafingTickTime < this.currentRecipe.getTickTime()) {
                        if (this.currentRecipe.getEuTick() > 0.0) {
                            this.addEnergy(this.currentRecipe.getEuTick());
                            ++this.crafingTickTime;
                        } else if (this.canUseEnergy(this.currentRecipe.getEuTick() * -1.0)) {
                            this.setEnergy(this.getEnergy() - this.currentRecipe.getEuTick() * -1.0);
                            ++this.crafingTickTime;
                        }
                    } else if (this.canFitStack(this.currentRecipe.getOutput(), this.outputStackSlot, true)) {
                        if (this.func_70301_a(this.outputStackSlot) == null) {
                            this.func_70299_a(this.outputStackSlot, this.currentRecipe.getOutput().func_77946_l());
                        } else {
                            this.func_70298_a(this.outputStackSlot, -this.currentRecipe.getOutput().field_77994_a);
                        }
                        this.func_70298_a(this.topStackSlot, this.currentRecipe.getTopInput().field_77994_a);
                        if (this.currentRecipe.getBottomInput() != null) {
                            this.func_70298_a(this.bottomStackSlot, this.currentRecipe.getBottomInput().field_77994_a);
                        }
                        this.resetCrafter();
                    }
                }
            } else if (this.currentRecipe != null) {
                this.resetCrafter();
            }
        }
        if (this.inventory.hasChanged) {
            this.inventory.hasChanged = false;
        }
    }

    private boolean validateRecipe() {
        if (ItemUtils.isItemEqual((ItemStack)this.func_70301_a(this.topStackSlot), (ItemStack)this.currentRecipe.getTopInput(), (boolean)true, (boolean)true, (boolean)true)) {
            if (this.currentRecipe.getBottomInput() != null && !ItemUtils.isItemEqual((ItemStack)this.func_70301_a(this.bottomStackSlot), (ItemStack)this.currentRecipe.getBottomInput(), (boolean)true, (boolean)true, (boolean)true)) {
                return false;
            }
            if (this.canFitStack(this.currentRecipe.getOutput(), this.outputStackSlot, true)) {
                return true;
            }
        }
        return false;
    }

    private void resetCrafter() {
        this.currentRecipe = null;
        this.crafingTickTime = -1;
        this.finalTickTime = -1;
        this.neededPower = -1;
        this.hasStartedCrafting = false;
    }

    public boolean canFitStack(ItemStack stack, int slot, boolean oreDic) {
        if (stack == null) {
            return true;
        }
        if (this.inventory.func_70301_a(slot) == null) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(slot), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)oreDic) && stack.field_77994_a + this.inventory.func_70301_a((int)slot).field_77994_a <= stack.func_77976_d();
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }
}

