/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import ic2.api.tile.IWrenchable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

public class TileGenerator
extends TilePowerAcceptor
implements IWrenchable,
IInventory {
    public Inventory inventory = new Inventory(2, "TileGenerator", 64, (TileEntity)this);
    public int fuelSlot = 0;
    public int burnTime;
    public int totalBurnTime = 0;
    public static int outputAmount = 40;
    public boolean isBurning;
    public boolean lastTickBurning;
    ItemStack burnItem;

    public TileGenerator() {
        super(1);
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getEnergy() < this.getMaxPower()) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.addEnergy(outputAmount);
                this.isBurning = true;
            }
        } else {
            this.isBurning = false;
        }
        if (this.burnTime == 0) {
            this.updateState();
            this.burnTime = this.totalBurnTime = TileGenerator.getItemBurnTime(this.func_70301_a(this.fuelSlot));
            if (this.burnTime > 0) {
                this.updateState();
                this.burnItem = this.func_70301_a(this.fuelSlot);
                if (this.func_70301_a((int)this.fuelSlot).field_77994_a == 1) {
                    this.func_70299_a(this.fuelSlot, null);
                } else {
                    this.func_70298_a(this.fuelSlot, 1);
                }
            }
        }
        this.lastTickBurning = this.isBurning;
    }

    public void updateState() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (blockState.func_177230_c() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)blockState.func_177230_c();
            if ((Boolean)blockState.func_177229_b((IProperty)BlockMachineBase.ACTIVE) != this.burnTime > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.burnTime > 0), this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.inventory.func_70301_a(p_70301_1_);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return this.inventory.func_70298_a(p_70298_1_, p_70298_2_);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return this.inventory.func_70304_b(p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.inventory.func_70299_a(p_70299_1_, p_70299_2_);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.inventory.func_70300_a(p_70300_1_);
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return this.inventory.func_94041_b(p_94041_1_, p_94041_2_);
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getMaxOutput() {
        return 64.0;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public ItemStack getWrenchDrop(EntityPlayer p0) {
        return new ItemStack(ModBlocks.Generator);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }
}

