/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.idsu;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.TreeMap;
import net.minecraft.world.World;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IDSUManager {
    public static IDSUManager INSTANCE;
    public static final String savename = "idsu.json";
    public HashMap<World, IDSUWorldSaveData> worldData = new HashMap();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void worldSave(WorldEvent.Save event) {
        if (event.world != null && event.world.func_72860_G() != null && event.world.func_72860_G().func_75765_b() != null && this.worldData.containsKey(event.world)) {
            this.worldData.get(event.world).save();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void worldLoad(WorldEvent.Load event) {
        if (event.world != null && event.world.func_72860_G() != null && event.world.func_72860_G().func_75765_b() != null) {
            if (this.worldData.containsKey(event.world)) {
                this.worldData.get(event.world).load();
            } else {
                IDSUWorldSaveData worldSaveData = new IDSUWorldSaveData(event.world);
                this.worldData.put(event.world, worldSaveData);
                worldSaveData.load();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void worldClosed(WorldEvent.Unload event) {
        if (event.world != null && event.world.func_72860_G() != null && event.world.func_72860_G().func_75765_b() != null && this.worldData.containsKey(event.world)) {
            this.worldData.get(event.world).save();
        }
        this.worldData.clear();
    }

    public IDSUValueSaveData getSaveDataForWorld(World world, String channel) {
        if (this.worldData.containsKey(world)) {
            return this.worldData.get(world).getSaves(channel);
        }
        IDSUWorldSaveData worldSaveData = new IDSUWorldSaveData(world);
        this.worldData.put(world, worldSaveData);
        worldSaveData.load();
        return worldSaveData.getSaves(channel);
    }

    public IDSUWorldSaveData getWorldDataFormWorld(World world) {
        if (this.worldData.containsKey(world)) {
            return this.worldData.get(world);
        }
        IDSUWorldSaveData worldSaveData = new IDSUWorldSaveData(world);
        this.worldData.put(world, worldSaveData);
        worldSaveData.load();
        return worldSaveData;
    }

    public void loadFromString(String json, World world) {
        IDSUWorldSaveData worldSaveData;
        if (json.equals("EMPTY")) {
            return;
        }
        if (this.worldData.containsKey(world)) {
            worldSaveData = this.worldData.get(world);
        } else {
            worldSaveData = new IDSUWorldSaveData(world);
            this.worldData.put(world, worldSaveData);
        }
        Gson gson = new Gson();
        Type typeOfHashMap = new TypeToken<TreeMap<Integer, IDSUValueSaveData>>(){}.getType();
        worldSaveData.idsuValues.clear();
        worldSaveData.idsuValues = (TreeMap)gson.fromJson(json, typeOfHashMap);
    }

    public class IDSUValueSaveData {
        public double storedPower = 0.0;

        public IDSUValueSaveData(double storedPower) {
            this.storedPower = storedPower;
        }

        public IDSUValueSaveData() {
        }

        public double getStoredPower() {
            return this.storedPower;
        }

        public void setStoredPower(double storedPower) {
            this.storedPower = storedPower;
        }

        public void addEnergy(double storedPower) {
            this.storedPower += storedPower;
        }
    }

    public class IDSUWorldSaveData {
        public TreeMap<String, IDSUValueSaveData> idsuValues = new TreeMap();
        public World world;
        ISaveHandler saveHandler;
        File folder;
        File file;

        public IDSUWorldSaveData(World world) {
            this.world = world;
            this.saveHandler = world.func_72860_G();
            this.folder = new File(this.saveHandler.func_75765_b(), "idsuData");
            this.file = new File(this.folder, IDSUManager.savename);
        }

        public IDSUValueSaveData getSaves(String udid) {
            if (udid == null) {
                return null;
            }
            if (this.idsuValues.containsKey(udid)) {
                return this.idsuValues.get(udid);
            }
            IDSUValueSaveData data = new IDSUValueSaveData();
            this.idsuValues.put(udid, data);
            return data;
        }

        public void load() {
            if (!this.file.exists()) {
                return;
            }
            try {
                Gson gson = new Gson();
                BufferedReader reader = new BufferedReader(new FileReader(this.file));
                Type typeOfHashMap = new TypeToken<TreeMap<String, IDSUValueSaveData>>(){}.getType();
                this.idsuValues.clear();
                this.idsuValues = (TreeMap)gson.fromJson((Reader)reader, typeOfHashMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void save() {
            if (this.idsuValues.isEmpty()) {
                return;
            }
            if (!this.file.exists()) {
                if (!this.folder.exists()) {
                    this.folder.mkdirs();
                }
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(this.idsuValues);
            try {
                FileWriter writer = new FileWriter(this.file);
                writer.write(json);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

