/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import reborncore.common.misc.ChunkCoord;
import techreborn.Core;

public class TechRebornRetroGen {
    private static final String RETROGEN_TAG = "techrebonr:retogen";
    private static final Set<ChunkCoord> completedChunks = Sets.newHashSet();
    private final Deque<ChunkCoord> chunksToRetroGen = new ArrayDeque<ChunkCoord>(64);

    private boolean isChunkEligibleForRetroGen(ChunkDataEvent.Load event) {
        return Core.worldGen.config.retroGenOres && event.world.field_73011_w.func_177502_q() == 0 && event.getData().func_74779_i(RETROGEN_TAG).isEmpty();
    }

    public void markChunk(ChunkCoord coord) {
        completedChunks.add(coord);
    }

    private boolean isTickEligibleForRetroGen(TickEvent.WorldTickEvent event) {
        return event.phase == TickEvent.Phase.END || event.side == Side.SERVER;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (this.isTickEligibleForRetroGen(event) && !this.chunksToRetroGen.isEmpty()) {
            ChunkCoord coord = this.chunksToRetroGen.pollFirst();
            Core.logHelper.info((Object)("Regenerating ore in " + coord + '.'));
            World world = event.world;
            if (world.func_72863_F().func_73149_a(coord.getX(), coord.getZ())) {
                long seed = world.func_72905_C();
                Random rng = new Random(seed);
                long xSeed = rng.nextLong() >> 3;
                long zSeed = rng.nextLong() >> 3;
                long chunkSeed = (xSeed * (long)coord.getX() + zSeed * (long)coord.getZ()) * seed;
                rng.setSeed(chunkSeed);
                Core.worldGen.generate(rng, coord.getX() << 4, coord.getZ() << 4, world, null, null);
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        if (this.isChunkEligibleForRetroGen(event)) {
            ChunkCoord coord = ChunkCoord.of((ChunkEvent)event);
            Core.logHelper.info((Object)("Queueing retro ore gen for " + coord + '.'));
            this.chunksToRetroGen.addLast(coord);
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        ChunkCoord coord = ChunkCoord.of((ChunkEvent)event);
        if (completedChunks.contains(coord)) {
            event.getData().func_74778_a(RETROGEN_TAG, "X");
            completedChunks.remove(coord);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("chunksToRetroGen", this.chunksToRetroGen).toString();
    }
}

