/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import reborncore.common.misc.ChunkCoord;
import techreborn.Core;
import techreborn.init.ModBlocks;
import techreborn.world.RubberTreeGenerator;
import techreborn.world.TechRebornRetroGen;
import techreborn.world.config.OreConfig;
import techreborn.world.config.WorldGenConfig;

public class TechRebornWorldGen
implements IWorldGenerator {
    WorldGenConfig config;
    WorldGenConfig defaultConfig;
    public File configFile;
    public static RubberTreeGenerator treeGenerator = new RubberTreeGenerator();
    public boolean jsonInvalid = false;
    public final TechRebornRetroGen retroGen = new TechRebornRetroGen();

    private void init() {
        this.defaultConfig = new WorldGenConfig();
        this.defaultConfig.overworldOres = new ArrayList<OreConfig>();
        this.defaultConfig.endOres = new ArrayList<OreConfig>();
        this.defaultConfig.neatherOres = new ArrayList<OreConfig>();
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Galena"), 8, 16, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Iridium"), 1, 1, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Ruby"), 6, 3, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Sapphire"), 6, 3, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Bauxite"), 6, 10, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Tetrahedrite"), 6, 16, 10, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Cassiterite"), 6, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Lead"), 6, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Silver"), 6, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Copper"), 8, 16, 20, 60));
        this.defaultConfig.overworldOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Tin"), 8, 16, 20, 60));
        this.defaultConfig.neatherOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Pyrite"), 6, 3, 10, 250));
        this.defaultConfig.neatherOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Cinnabar"), 6, 3, 10, 250));
        this.defaultConfig.neatherOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Sphalerite"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Tungston"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Sheldonite"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Peridot"), 6, 3, 10, 250));
        this.defaultConfig.endOres.add(new OreConfig(ModBlocks.ore.getBlockStateFromName("Sodalite"), 6, 3, 10, 250));
    }

    public void load() {
        this.init();
        if (this.configFile.exists()) {
            this.loadFromJson();
        } else {
            this.config = this.defaultConfig;
        }
        this.config.overworldOres.addAll(this.getMissingOres(this.config.overworldOres, this.defaultConfig.overworldOres));
        this.config.neatherOres.addAll(this.getMissingOres(this.config.neatherOres, this.defaultConfig.neatherOres));
        this.config.endOres.addAll(this.getMissingOres(this.config.endOres, this.defaultConfig.endOres));
        if (!this.jsonInvalid) {
            this.save();
        }
    }

    private List<OreConfig> getMissingOres(List<OreConfig> config, List<OreConfig> defaultOres) {
        ArrayList<OreConfig> missingOres = new ArrayList<OreConfig>();
        for (OreConfig defaultOre : defaultOres) {
            boolean hasFoundOre = false;
            for (OreConfig ore : config) {
                if (!ore.blockName.equals(defaultOre.blockName) || ore.meta != defaultOre.meta) continue;
                hasFoundOre = true;
                ore.state = defaultOre.state;
            }
            if (hasFoundOre) continue;
            missingOres.add(defaultOre);
        }
        return missingOres;
    }

    private void loadFromJson() {
        try {
            Gson gson = new Gson();
            BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
            Type typeOfHashMap = new TypeToken<WorldGenConfig>(){}.getType();
            this.config = (WorldGenConfig)gson.fromJson((Reader)reader, typeOfHashMap);
        }
        catch (Exception e) {
            Core.logHelper.error((Object)"The ores.json file was invalid, bad things are about to happen, I will try and save the world now :");
            this.config = this.defaultConfig;
            this.jsonInvalid = true;
            Core.logHelper.error((Object)"The ores.json file was ignored and the default values loaded, you file will NOT be over written");
            e.printStackTrace();
        }
    }

    private void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this.config);
        try {
            FileWriter writer = new FileWriter(this.configFile);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            Core.logHelper.error((Object)"The ores.json file was invalid, something bad happened");
            e.printStackTrace();
        }
    }

    public List<OreConfig> getAllGenOresFromList(List<OreConfig> configList) {
        ArrayList<OreConfig> list = new ArrayList<OreConfig>();
        for (OreConfig config : configList) {
            if (config.veinSize == 0 || config.veinsPerChunk == 0 || !config.shouldSpawn) continue;
            list.add(config);
        }
        return list;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, @Nullable IChunkProvider chunkGenerator, @Nullable IChunkProvider chunkProvider) {
        if (!this.config.generateTechRebornFeatures) {
            return;
        }
        boolean genTree = false;
        ArrayList<OreConfig> list = new ArrayList<OreConfig>();
        if (world.field_73011_w.func_76569_d()) {
            list.addAll(this.getAllGenOresFromList(this.config.overworldOres));
            genTree = true;
        } else if (world.field_73011_w.func_177502_q() == 0) {
            list.addAll(this.getAllGenOresFromList(this.config.neatherOres));
        } else if (world.field_73011_w.func_177502_q() == 1) {
            list.addAll(this.getAllGenOresFromList(this.config.endOres));
        }
        if (!list.isEmpty() && this.config.generateOres) {
            for (OreConfig ore : list) {
                WorldGenMinable worldGenMinable = new WorldGenMinable(ore.state, ore.veinSize);
                for (int i = 0; i < ore.veinsPerChunk; ++i) {
                    int xPos = chunkX * 16 + random.nextInt(16);
                    int yPos = 10 + random.nextInt(ore.maxYHeight - ore.minYHeight);
                    int zPos = chunkZ * 16 + random.nextInt(16);
                    BlockPos pos = new BlockPos(xPos, yPos, zPos);
                    worldGenMinable.func_180709_b(world, random, pos);
                }
            }
        }
        if (genTree && this.config.rubberTreeConfig.shouldSpawn) {
            int chance = this.config.rubberTreeConfig.chance;
            boolean isValidSpawn = false;
            BiomeGenBase biomeGenBase = world.func_180494_b(new BlockPos(chunkX * 16, 72, chunkZ * 16));
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                chance -= random.nextInt(10) + 10;
                isValidSpawn = true;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                chance -= random.nextInt(5) + 3;
                isValidSpawn = true;
            }
            if (!isValidSpawn) {
                return;
            }
            if (random.nextInt(chance) == 0) {
                int x = chunkX * 16 + random.nextInt(15);
                int z = chunkZ * 16 + random.nextInt(15);
                for (int i = 0; i < this.config.rubberTreeConfig.clusterSize; ++i) {
                    for (int y = world.func_72940_L() - 1; world.func_175623_d(new BlockPos(x, y, z)) && y > 0; --y) {
                    }
                    treeGenerator.func_180709_b(world, random, new BlockPos(x, 72, z));
                    x += random.nextInt(16) - 8;
                    z += random.nextInt(16) - 8;
                }
            }
            this.retroGen.markChunk(ChunkCoord.of((int)chunkX, (int)chunkZ));
        }
    }
}

