/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import ic2.api.item.IC2Items;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import techreborn.api.recipe.IRecipeCompact;
import techreborn.blocks.BlockMachineFrame;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.DynamicCell;
import techreborn.items.ItemIngots;
import techreborn.items.ItemParts;
import techreborn.items.ItemPlates;
import techreborn.parts.powerCables.ItemStandaloneCables;

public class RecipeCompact
implements IRecipeCompact {
    HashMap<String, ItemStack> recipes = new HashMap();
    ArrayList<String> missingItems = new ArrayList();
    HashMap<String, Ic2ItemLookup> lookupHashMap = new HashMap();
    boolean inited = false;

    public void init() {
        this.recipes.put("industrialDiamond", new ItemStack(Items.field_151045_i));
        this.recipes.put("industrialTnt", new ItemStack(Blocks.field_150335_W));
        this.recipes.put("copperIngot", ItemIngots.getIngotByName("copper"));
        this.recipes.put("tinIngot", ItemIngots.getIngotByName("tin"));
        this.recipes.put("bronzeIngot", ItemIngots.getIngotByName("bronze"));
        this.recipes.put("leadIngot", ItemIngots.getIngotByName("lead"));
        this.recipes.put("silverIngot", ItemIngots.getIngotByName("silver"));
        this.recipes.put("iridiumOre", ItemIngots.getIngotByName("iridium"));
        this.recipes.put("plateiron", ItemPlates.getPlateByName("iron"));
        this.recipes.put("iridiumPlate", ItemPlates.getPlateByName("iridium"));
        this.recipes.put("cell", new ItemStack(ModItems.emptyCell));
        this.recipes.put("airCell", new ItemStack(ModItems.emptyCell));
        this.recipes.put("electronicCircuit", ItemParts.getPartByName("electronicCircuit"));
        this.recipes.put("advancedCircuit", ItemParts.getPartByName("advancedCircuit"));
        this.recipes.put("rubberWood", new ItemStack(ModBlocks.rubberLog));
        this.recipes.put("resin", ItemParts.getPartByName("rubberSap"));
        this.recipes.put("carbonPlate", ItemPlates.getPlateByName("carbon"));
        this.recipes.put("reBattery", new ItemStack(ModItems.reBattery));
        this.recipes.put("machine", BlockMachineFrame.getFrameByName("machine", 1));
        this.recipes.put("advancedMachine", BlockMachineFrame.getFrameByName("advancedMachine", 1));
        this.recipes.put("extractor", new ItemStack(ModBlocks.Extractor));
        this.recipes.put("generator", new ItemStack(ModBlocks.Generator));
        this.recipes.put("macerator", new ItemStack(ModBlocks.Grinder));
        this.recipes.put("diamondDrill", new ItemStack(ModItems.diamondDrill));
        this.recipes.put("miningDrill", new ItemStack(ModItems.ironDrill));
        this.recipes.put("solarPanel", new ItemStack(ModBlocks.solarPanel));
        this.recipes.put("waterCell", DynamicCell.getCellWithFluid(FluidRegistry.WATER));
        this.recipes.put("lavaCell", DynamicCell.getCellWithFluid(FluidRegistry.LAVA));
        this.recipes.put("pump", new ItemStack(ModBlocks.pump));
        this.recipes.put("advancedAlloy", ItemIngots.getIngotByName("advancedAlloy"));
        this.recipes.put("lvTransformer", new ItemStack(ModBlocks.lvt));
        this.recipes.put("mvTransformer", new ItemStack(ModBlocks.mvt));
        this.recipes.put("hvTransformer", new ItemStack(ModBlocks.hvt));
        this.recipes.put("windMill", new ItemStack(ModBlocks.windMill));
        this.recipes.put("energyCrystal", new ItemStack(ModItems.energyCrystal));
        this.recipes.put("lapotronCrystal", new ItemStack(ModItems.lapotronCrystal));
        this.recipes.put("reinforcedGlass", new ItemStack(ModBlocks.reinforcedglass));
        this.recipes.put("compressor", new ItemStack(ModBlocks.Compressor));
        this.recipes.put("insulatedGoldCableItem", ItemStandaloneCables.getCableByName("insulatedgold"));
        this.recipes.put("fertilizer", new ItemStack(Items.field_151100_aR));
        this.lookupHashMap.put("miningDrill", new Ic2ItemLookup("drill"));
        this.lookupHashMap.put("reBattery", new Ic2ItemLookup("re_battery"));
        this.lookupHashMap.put("electronicCircuit", new Ic2ItemLookup("crafting", "circuit"));
        this.lookupHashMap.put("advancedCircuit", new Ic2ItemLookup("crafting", "advanced_circuit"));
        this.lookupHashMap.put("lapotronCrystal", new Ic2ItemLookup("lapotron_crystal"));
        this.lookupHashMap.put("lapotronCrystal", new Ic2ItemLookup("lapotron_crystal"));
        this.lookupHashMap.put("iridiumPlate", new Ic2ItemLookup(ItemPlates.getPlateByName("iridium")));
        this.lookupHashMap.put("advancedMachine", new Ic2ItemLookup("resource", "advanced_machine"));
        this.lookupHashMap.put("windMill", new Ic2ItemLookup("te", "wind_generator"));
        this.lookupHashMap.put("reinforcedGlass", new Ic2ItemLookup("glass", "reinforced"));
        this.lookupHashMap.put("extractor", new Ic2ItemLookup("te", "extractor"));
        this.lookupHashMap.put("machine", new Ic2ItemLookup("resource", "machine"));
        this.lookupHashMap.put("hvTransformer", new Ic2ItemLookup("te", "hv_transformer"));
        this.lookupHashMap.put("generator", new Ic2ItemLookup("te", "generator"));
        this.lookupHashMap.put("rubberWood", new Ic2ItemLookup("rubber_wood"));
        this.lookupHashMap.put("industrialTnt", new Ic2ItemLookup("te", "itnt"));
        this.lookupHashMap.put("industrialDiamond", new Ic2ItemLookup("crafting", "industrial_diamond"));
        this.lookupHashMap.put("macerator", new Ic2ItemLookup("te", "macerator"));
        this.lookupHashMap.put("diamondDrill", new Ic2ItemLookup("diamond_drill"));
        this.lookupHashMap.put("solarPanel", new Ic2ItemLookup("te", "solar_generator"));
        this.lookupHashMap.put("insulatedGoldCableItem", new Ic2ItemLookup("cable", "type:gold,insulation:1"));
        this.inited = false;
    }

    @Override
    public ItemStack getItem(String name) {
        if (!this.inited) {
            this.init();
        }
        if (Loader.isModLoaded((String)"IC2")) {
            ItemStack stack = IC2Items.getItem((String)name);
            if (stack == null) {
                if (this.lookupHashMap.containsKey(name)) {
                    Ic2ItemLookup lookup = this.lookupHashMap.get(name);
                    if (lookup.getStack() != null) {
                        return lookup.getStack();
                    }
                    return IC2Items.getItem((String)lookup.getName(), (String)lookup.getVariant());
                }
                String line = "IC2:" + name;
                if (!this.missingItems.contains(line)) {
                    this.missingItems.add(line);
                }
            } else {
                return stack;
            }
        }
        if (!this.recipes.containsKey(name)) {
            if (!this.missingItems.contains(name)) {
                this.missingItems.add(name);
            }
            return new ItemStack(ModItems.missingRecipe);
        }
        return this.recipes.get(name);
    }

    public void saveMissingItems(File mcDir) throws IOException {
        File missingItemsFile = new File(mcDir, "missingItems.txt");
        if (missingItemsFile.exists()) {
            missingItemsFile.delete();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(missingItemsFile));
        for (String str : this.missingItems) {
            writer.write(str);
            writer.newLine();
        }
        writer.close();
    }

    class Ic2ItemLookup {
        @Nullable
        String name;
        @Nullable
        String variant;
        @Nullable
        ItemStack stack;

        public Ic2ItemLookup(String name, String variant) {
            this.name = name;
            this.variant = variant;
        }

        public Ic2ItemLookup(String name) {
            this.name = name;
        }

        public Ic2ItemLookup(ItemStack stack) {
            this.stack = stack;
        }

        public String getName() {
            return this.name;
        }

        public String getVariant() {
            return this.variant;
        }

        @Nullable
        public ItemStack getStack() {
            return this.stack;
        }
    }
}

