/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import org.apache.commons.lang3.Validate;
import techreborn.client.TechRebornCreativeTab;
import techreborn.init.ModItems;

public class DynamicCell
extends UniversalBucket {
    public DynamicCell() {
        super(1000, new ItemStack(ModItems.emptyCell), false);
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77655_b("techreborn.cellFilled");
        this.func_77625_d(16);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer player, EnumHand hand) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
    }

    public void onFillBucket(FillBucketEvent event) {
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            if (this.getEmpty() != null) {
                return this.getEmpty().func_82833_r();
            }
            return super.func_77653_i(stack);
        }
        return fluidStack.getLocalizedName() + " Cell";
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.field_77994_a != 1) {
            return 0;
        }
        if (resource == null || resource.amount != this.getCapacity()) {
            return 0;
        }
        if (doFill) {
            NBTTagCompound tag = container.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            resource.writeToNBT(tag);
            container.func_77982_d(tag);
        }
        return this.getCapacity();
    }

    public static ItemStack getCellWithFluid(Fluid fluid, int stackSize) {
        Validate.notNull((Object)fluid);
        ItemStack stack = new ItemStack((Item)ModItems.dynamicCell, stackSize);
        ModItems.dynamicCell.fill(stack, new FluidStack(fluid, ModItems.dynamicCell.getCapacity()), true);
        return stack;
    }

    public static ItemStack getCellWithFluid(Fluid fluid) {
        return DynamicCell.getCellWithFluid(fluid, 1);
    }
}

