/*
 * Decompiled with CFR 0.152.
 */
package techreborn.parts;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import reborncore.mcmultipart.multipart.MultipartRegistry;
import techreborn.compat.ICompatModule;
import techreborn.parts.fluidPipes.EmptyFluidPipe;
import techreborn.parts.fluidPipes.ExtractingFluidPipe;
import techreborn.parts.fluidPipes.InsertingFluidPipe;
import techreborn.parts.fluidPipes.ItemFluidPipe;
import techreborn.parts.powerCables.CableMultipart;
import techreborn.parts.powerCables.EnumCableType;
import techreborn.parts.powerCables.ItemCables;

public class TechRebornParts
implements ICompatModule {
    @Nullable
    public static Item cables;
    @Nullable
    public static Item fluidPipe;
    public static HashMap<EnumCableType, Class<? extends CableMultipart>> multipartHashMap;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        for (EnumCableType cableType : EnumCableType.values()) {
            multipartHashMap.put(cableType, cableType.cableClass);
            MultipartRegistry.registerPart(cableType.cableClass, (String)("techreborn:cable." + cableType.name()));
        }
        cables = new ItemCables();
        cables.setRegistryName("cables");
        GameRegistry.register((IForgeRegistryEntry)cables);
        MultipartRegistry.registerPart(EmptyFluidPipe.class, (String)"techreborn:fluidpipe.empty");
        MultipartRegistry.registerPart(InsertingFluidPipe.class, (String)"techreborn:fluidpipe.inserting");
        MultipartRegistry.registerPart(ExtractingFluidPipe.class, (String)"techreborn:fluidpipe.extracting");
        fluidPipe = new ItemFluidPipe();
        fluidPipe.setRegistryName("fluidPipe");
        GameRegistry.register((IForgeRegistryEntry)fluidPipe);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
    }

    static {
        multipartHashMap = new HashMap();
    }
}

