/*
 * Decompiled with CFR 0.152.
 */
package techreborn.proxies;

import java.io.File;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import reborncore.RebornCore;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.common.blocks.BlockMachineBase;
import techreborn.blocks.BlockRubberLeaves;
import techreborn.client.ClientMultiBlocks;
import techreborn.client.IconSupplier;
import techreborn.client.RegisterItemJsons;
import techreborn.client.StackToolTipEvent;
import techreborn.client.hud.ChargeHud;
import techreborn.client.keybindings.KeyBindings;
import techreborn.client.render.entitys.RenderNukePrimed;
import techreborn.entitys.EntityNukePrimed;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.manual.loader.ManualLoader;
import techreborn.proxies.CommonProxy;

public class ClientProxy
extends CommonProxy {
    public static MultiblockRenderEvent multiblockRenderEvent;
    public static final ModelResourceLocation MODEL_DYNAMIC_CELL;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        RenderingRegistry.registerEntityRenderingHandler(EntityNukePrimed.class, (IRenderFactory)new RenderManagerNuke());
        ManualLoader loader = new ManualLoader(new File(event.getModConfigurationDirectory(), "techreborn"));
        for (Object object : RebornCore.jsonDestroyer.objectsToDestroy) {
            if (!(object instanceof BlockMachineBase)) continue;
            BlockMachineBase base = (BlockMachineBase)object;
            this.registerItemModel(Item.func_150898_a((Block)base));
        }
        ModelLoader.setCustomMeshDefinition((Item)ModItems.dynamicCell, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return MODEL_DYNAMIC_CELL;
            }
        });
        ModelBakery.registerItemVariants((Item)ModItems.dynamicCell, (ResourceLocation[])new ResourceLocation[]{MODEL_DYNAMIC_CELL});
        RegisterItemJsons.registerModels();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new IconSupplier());
        MinecraftForge.EVENT_BUS.register((Object)new ChargeHud());
        MinecraftForge.EVENT_BUS.register((Object)new StackToolTipEvent());
        multiblockRenderEvent = new MultiblockRenderEvent();
        ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.config);
        ClientMultiBlocks.init();
        StateMap rubberLeavesStateMap = new StateMap.Builder().func_178442_a(new IProperty[]{BlockRubberLeaves.field_176236_b, BlockRubberLeaves.field_176237_a}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)ModBlocks.rubberLeaves, (IStateMapper)rubberLeavesStateMap);
    }

    protected void registerItemModel(ItemStack item, String name) {
        ModelLoader.registerItemVariants((Item)item.func_77973_b(), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(name)});
        ModelLoader.setCustomModelResourceLocation((Item)item.func_77973_b(), (int)item.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    public ResourceLocation registerItemModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        return ClientProxy.registerIt(item, itemLocation);
    }

    public static ResourceLocation getItemLocation(Item item) {
        ResourceLocation o = item.getRegistryName();
        if (o == null) {
            return null;
        }
        return o;
    }

    private static ResourceLocation registerIt(Item item, final ResourceLocation location) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return new ModelResourceLocation(location, "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        return location;
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        super.registerFluidBlockRendering(block, name);
        final ModelResourceLocation fluidLocation = new ModelResourceLocation("techreborn".toLowerCase() + ":fluids", name);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }

    @Override
    public void registerCustomBlockSateLocation(Block block, final String resourceLocation) {
        super.registerCustomBlockSateLocation(block, resourceLocation);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                String resourceDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).func_110624_b();
                String propertyString = this.func_178131_a((Map)state.func_177228_b());
                return new ModelResourceLocation(resourceDomain + ':' + resourceLocation, propertyString);
            }
        });
        String resourceDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).func_110624_b();
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(resourceDomain + ':' + resourceLocation, "inventory"));
    }

    static {
        MODEL_DYNAMIC_CELL = new ModelResourceLocation(new ResourceLocation("techreborn", "dyncell"), "inventory");
    }

    public class RenderManagerNuke
    implements IRenderFactory<EntityNukePrimed> {
        public Render<? super EntityNukePrimed> createRenderFor(RenderManager manager) {
            return new RenderNukePrimed(manager);
        }
    }
}

