/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IContainerProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.container.RebornContainer;
import reborncore.common.powerSystem.PoweredItem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.client.container.ContainerCentrifuge;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;

public class TileCentrifuge
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IListInfoProvider,
IRecipeCrafterProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(11, "TileCentrifuge", 64, (TileEntity)this);
    public RecipeCrafter crafter;
    public int euTick = ConfigTechReborn.CentrifugeInputTick;

    public TileCentrifuge() {
        super(2);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4, 5};
        this.crafter = new RecipeCrafter(Reference.centrifugeRecipe, (TileMachineBase)this, 2, 4, this.inventory, inputs, outputs);
    }

    public void updateEntity() {
        IEnergyItemInfo item;
        ItemStack stack;
        super.updateEntity();
        this.crafter.updateEntity();
        this.charge(6);
        if (this.inventory.func_70301_a(6) != null && (stack = this.inventory.func_70301_a(6)).func_77973_b() instanceof IEnergyItemInfo && (item = (IEnergyItemInfo)stack.func_77973_b()).canProvideEnergy(stack) && this.getEnergy() != this.getMaxPower()) {
            this.addEnergy(item.getMaxTransfer(stack));
            PoweredItem.setEnergy((double)(PoweredItem.getEnergy((ItemStack)stack) - item.getMaxTransfer(stack)), (ItemStack)stack);
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.centrifuge, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        super.addInfo(info, isRealTile);
        info.add("Round and round it goes");
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    public RebornContainer getContainer() {
        return RebornContainer.getContainerFromClass(ContainerCentrifuge.class, (TileEntity)this);
    }
}

