/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.misc.Location;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileMachineCasing;

public class TileImplosionCompressor
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
ISidedInventory,
IRecipeCrafterProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(4, "TileImplosionCompressor", 64, (TileEntity)this);
    public RecipeCrafter crafter;

    public TileImplosionCompressor() {
        super(1);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3};
        this.crafter = new RecipeCrafter(Reference.implosionCompressorRecipe, (TileMachineBase)this, 2, 2, this.inventory, inputs, outputs);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ImplosionCompressor, 1);
    }

    public boolean getMutliBlock() {
        for (EnumFacing direction : EnumFacing.values()) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + direction.func_82601_c(), this.func_174877_v().func_177956_o() + direction.func_96559_d(), this.func_174877_v().func_177952_p() + direction.func_82599_e()));
            if (!(tileEntity instanceof TileMachineCasing)) continue;
            if (!((TileMachineCasing)tileEntity).isConnected()) {
                return false;
            }
            if (!(tileEntity.func_145838_q() instanceof BlockMachineCasing)) continue;
            BlockMachineCasing machineCasing = (BlockMachineCasing)tileEntity.func_145838_q();
            int heat = machineCasing.getHeatFromState(tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v()));
            Location location = new Location(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), direction);
            location.modifyPositionFromSide(direction, 1);
            if (this.field_145850_b.func_180495_p(new BlockPos(location.getX(), location.getY(), location.getZ())).func_177230_c().func_149739_a().equals("tile.lava")) {
                heat += 500;
            }
            return true;
        }
        return false;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.getMutliBlock()) {
            this.crafter.updateEntity();
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray = nArray2;
            nArray2[3] = 3;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray = nArray3;
            nArray3[3] = 3;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex >= 2) {
            return false;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2 || slotIndex == 3;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return 100000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 64.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }
}

