/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.Reference;
import techreborn.api.recipe.ITileRecipeHandler;
import techreborn.api.recipe.machines.IndustrialGrinderRecipe;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.init.ModFluids;
import techreborn.tiles.TileMachineCasing;

public class TileIndustrialGrinder
extends TilePowerAcceptor
implements IWrenchable,
IFluidHandler,
IInventoryProvider,
ISidedInventory,
ITileRecipeHandler<IndustrialGrinderRecipe>,
IRecipeCrafterProvider {
    public static final int TANK_CAPACITY = 16000;
    public int tickTime;
    public Inventory inventory = new Inventory(6, "TileGrinder", 64, (TileEntity)this);
    public Tank tank = new Tank("TileGrinder", 16000, (TileEntity)this);
    public RecipeCrafter crafter;
    public int connectionStatus;

    public TileIndustrialGrinder() {
        super(ConfigTechReborn.CentrifugeTier);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4, 5};
        this.crafter = new RecipeCrafter(Reference.industrialGrinderRecipe, (TileMachineBase)this, 1, 4, this.inventory, inputs, outputs);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.IndustrialGrinder, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public boolean getMutliBlock() {
        for (EnumFacing direction : EnumFacing.values()) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + direction.func_82601_c(), this.func_174877_v().func_177956_o() + direction.func_96559_d(), this.func_174877_v().func_177952_p() + direction.func_82599_e()));
            if (!(tileEntity instanceof TileMachineCasing) || !((TileMachineCasing)tileEntity).isConnected() || !((TileMachineCasing)tileEntity).getMultiblockController().isAssembled() || ((TileMachineCasing)tileEntity).getMultiblockController().height != 3) continue;
            this.connectionStatus = 1;
            return true;
        }
        this.connectionStatus = 0;
        return false;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.getMutliBlock()) {
            this.crafter.updateEntity();
        }
        FluidUtils.drainContainers((IFluidHandler)this, (IInventory)this.inventory, (int)0, (int)5);
        FluidUtils.drainContainers((IFluidHandler)this, (IInventory)this.inventory, (int)1, (int)5);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER || resource.getFluid() == ModFluids.fluidMercury || resource.getFluid() == ModFluids.fluidSodiumpersulfate) {
            int filled = this.tank.fill(resource, doFill);
            this.tank.compareAndUpdate();
            return filled;
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        FluidStack fluidStack = this.tank.drain(resource.amount, doDrain);
        this.tank.compareAndUpdate();
        return fluidStack;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(maxDrain, doDrain);
        this.tank.compareAndUpdate();
        return drained;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return fluid == FluidRegistry.WATER || fluid == ModFluids.fluidMercury || fluid == ModFluids.fluidSodiumpersulfate;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray = nArray2;
            nArray2[5] = 5;
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArray3[4] = 4;
            nArray = nArray3;
            nArray3[5] = 5;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex >= 2) {
            return false;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2 || slotIndex == 3 || slotIndex == 4 || slotIndex == 5;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    @Override
    public boolean canCraft(TileEntity tile, IndustrialGrinderRecipe recipe) {
        if (recipe.fluidStack == null) {
            return true;
        }
        if (tile instanceof TileIndustrialGrinder) {
            TileIndustrialGrinder grinder = (TileIndustrialGrinder)tile;
            if (grinder.tank.getFluid() == null) {
                return false;
            }
            if (grinder.tank.getFluid() == recipe.fluidStack && grinder.tank.getFluidAmount() >= recipe.fluidStack.amount) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onCraft(TileEntity tile, IndustrialGrinderRecipe recipe) {
        if (recipe.fluidStack == null) {
            return true;
        }
        if (tile instanceof TileIndustrialGrinder) {
            TileIndustrialGrinder grinder = (TileIndustrialGrinder)tile;
            if (grinder.tank.getFluid() == null) {
                return false;
            }
            if (grinder.tank.getFluid() == recipe.fluidStack && grinder.tank.getFluidAmount() >= recipe.fluidStack.amount) {
                if (grinder.tank.getFluidAmount() > 0) {
                    grinder.tank.setFluid(new FluidStack(recipe.fluidStack.getFluid(), grinder.tank.getFluidAmount() - recipe.fluidStack.amount));
                } else {
                    grinder.tank.setFluid(null);
                }
                return true;
            }
        }
        return false;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }
}

