/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.api.recipe.ITileRecipeHandler;
import techreborn.api.recipe.machines.VacuumFreezerRecipe;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;

public class TileVacuumFreezer
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
ITileRecipeHandler<VacuumFreezerRecipe>,
IRecipeCrafterProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(3, "TileVacuumFreezer", 64, (TileEntity)this);
    public RecipeCrafter crafter;
    public int multiBlockStatus = 0;

    public TileVacuumFreezer() {
        super(2);
        int[] inputs = new int[]{0};
        int[] outputs = new int[]{1};
        this.crafter = new RecipeCrafter(Reference.vacuumFreezerRecipe, (TileMachineBase)this, 2, 1, this.inventory, inputs, outputs);
    }

    public void updateEntity() {
        super.updateEntity();
        this.crafter.updateEntity();
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.multiBlockStatus = this.checkMachine() ? 1 : 0;
        }
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 128.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.MEDIUM;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.AlloySmelter, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public boolean checkMachine() {
        int xDir = EnumFacing.UP.func_82601_c() * 2;
        int yDir = EnumFacing.UP.func_96559_d() * 2;
        int zDir = EnumFacing.UP.func_82599_e() * 2;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (i != 0 || j != 0 || k != 0) {
                        if (this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() - xDir + i, this.func_174877_v().func_177956_o() - yDir + j, this.func_174877_v().func_177952_p() - zDir + k)).func_177230_c() != ModBlocks.MachineCasing) {
                            return false;
                        }
                        IBlockState BlockStateContainer2 = this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() - xDir + i, this.func_174877_v().func_177956_o() - yDir + j, this.func_174877_v().func_177952_p() - zDir + k));
                        BlockMachineCasing blockMachineCasing = (BlockMachineCasing)BlockStateContainer2.func_177230_c();
                        if (blockMachineCasing.func_176201_c(BlockStateContainer2) == (i == 0 && j == 0 && k != 0 || i == 0 && j != 0 && k == 0 || i != 0 && j == 0 && k == 0 ? 2 : 1)) continue;
                        return false;
                    }
                    if (this.field_145850_b.func_175623_d(new BlockPos(this.func_174877_v().func_177958_n() - xDir + i, this.func_174877_v().func_177956_o() - yDir + j, this.func_174877_v().func_177952_p() - zDir + k))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean canCraft(TileEntity tile, VacuumFreezerRecipe recipe) {
        return tile instanceof TileVacuumFreezer && ((TileVacuumFreezer)tile).multiBlockStatus == 1;
    }

    @Override
    public boolean onCraft(TileEntity tile, VacuumFreezerRecipe recipe) {
        return true;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }
}

