/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.teir1;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

public class TileElectricFurnace
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
ISidedInventory {
    public Inventory inventory = new Inventory(6, "TileElectricFurnace", 64, (TileEntity)this);
    public int capacity = 1000;
    public int progress;
    public int fuelScale = 100;
    public int cost = 8;
    int input1 = 0;
    int output = 1;
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private static final int[] SLOTS_SIDES = new int[]{1};

    public TileElectricFurnace() {
        super(1);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.fuelScale;
    }

    public void updateEntity() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.isBurning() && this.canSmelt()) {
            this.updateState();
            ++this.progress;
            if (this.progress % 10 == 0) {
                this.useEnergy(this.cost);
            }
            if (this.progress >= this.fuelScale) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
            this.updateState();
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
            if (this.func_70301_a(this.output) == null) {
                this.func_70299_a(this.output, itemstack.func_77946_l());
            } else if (this.func_70301_a(this.output).func_77969_a(itemstack)) {
                this.func_70301_a((int)this.output).field_77994_a += itemstack.field_77994_a;
            }
            if (this.func_70301_a((int)this.input1).field_77994_a > 1) {
                this.func_70298_a(this.input1, 1);
            } else {
                this.func_70299_a(this.input1, null);
            }
        }
    }

    public boolean canSmelt() {
        if (this.func_70301_a(this.input1) == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
        if (itemstack == null) {
            return false;
        }
        if (this.func_70301_a(this.output) == null) {
            return true;
        }
        if (!this.func_70301_a(this.output).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.func_70301_a((int)this.output).field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public boolean isBurning() {
        return this.getEnergy() > (double)this.cost;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        if (result != null) {
            return result.func_77946_l();
        }
        return null;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (BlockStateContainer2.func_177230_c() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.func_177230_c();
            if ((Boolean)BlockStateContainer2.func_177229_b((IProperty)BlockMachineBase.ACTIVE) != this.progress > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.progress > 0), this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ElectricFurnace, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex == 2) {
            return false;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

