/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.cable;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.common.network.ClientBoundPackets;
import reborncore.common.network.IdentifiedPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleSidedEnergyContainer;
import techreborn.blockentity.cable.CableTickManager;
import techreborn.blockentity.cable.OfferedEnergyStorage;
import techreborn.blocks.cable.CableBlock;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class CableBlockEntity
extends class_2586
implements class_5558<CableBlockEntity>,
IListInfoProvider,
IToolDrop {
    final SimpleSidedEnergyContainer energyContainer = new SimpleSidedEnergyContainer(){

        public long getCapacity() {
            return (long)CableBlockEntity.this.getCableType().transferRate * 4L;
        }

        public long getMaxInsert(class_2350 side) {
            if (CableBlockEntity.this.allowTransfer(side)) {
                return CableBlockEntity.this.getCableType().transferRate;
            }
            return 0L;
        }

        public long getMaxExtract(class_2350 side) {
            if (CableBlockEntity.this.allowTransfer(side)) {
                return CableBlockEntity.this.getCableType().transferRate;
            }
            return 0L;
        }
    };
    private TRContent.Cables cableType = null;
    private class_2680 cover = null;
    long lastTick = 0L;
    List<CableTarget> targets = null;
    int blockedSides = 0;
    boolean ioBlocked = false;

    public CableBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.CABLE, pos, state);
    }

    public CableBlockEntity(class_2338 pos, class_2680 state, TRContent.Cables type) {
        super(TRBlockEntities.CABLE, pos, state);
        this.cableType = type;
    }

    TRContent.Cables getCableType() {
        if (this.cableType != null) {
            return this.cableType;
        }
        if (this.field_11863 == null) {
            return TRContent.Cables.COPPER;
        }
        class_2248 block = this.field_11863.method_8320(this.field_11867).method_26204();
        if (block instanceof CableBlock) {
            return ((CableBlock)block).type;
        }
        return TRContent.Cables.COPPER;
    }

    private boolean allowTransfer(class_2350 side) {
        return !this.ioBlocked && (this.blockedSides & 1 << side.ordinal()) == 0;
    }

    public EnergyStorage getSideEnergyStorage(@Nullable class_2350 side) {
        return this.energyContainer.getSideStorage(side);
    }

    public class_2680 getCover() {
        return this.cover;
    }

    public void setCover(class_2680 cover) {
        this.cover = cover;
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            NetworkManager.sendToTracking((IdentifiedPacket)ClientBoundPackets.createCustomDescriptionPacket((class_2586)this), (class_2586)this);
        }
    }

    public long getEnergy() {
        return this.energyContainer.amount;
    }

    public void setEnergy(long energy) {
        this.energyContainer.amount = energy;
    }

    public class_2487 method_16887() {
        return this.method_11007(new class_2487());
    }

    public class_2622 method_16886() {
        class_2487 nbtTag = new class_2487();
        this.method_11007(nbtTag);
        return new class_2622(this.method_11016(), 1, nbtTag);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10545("energy")) {
            this.energyContainer.amount = compound.method_10537("energy");
        }
        this.cover = compound.method_10545("cover") ? class_2512.method_10681((class_2487)compound.method_10562("cover")) : null;
    }

    public class_2487 method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10544("energy", this.energyContainer.amount);
        if (this.cover != null) {
            compound.method_10566("cover", (class_2520)class_2512.method_10686((class_2680)this.cover));
        }
        return compound;
    }

    public void neighborUpdate() {
        this.targets = null;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, CableBlockEntity blockEntity2) {
        if (world == null || world.field_9236) {
            return;
        }
        CableTickManager.handleCableTick(this);
    }

    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        info.add((class_2561)new class_2588("techreborn.tooltip.transferRate").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower((double)this.getCableType().transferRate)).method_27692(class_124.field_1065).method_27693("/t"));
        info.add((class_2561)new class_2588("techreborn.tooltip.tier").method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)new class_2585(StringUtils.toFirstCapitalAllLowercase((String)this.getCableType().tier.toString())).method_27692(class_124.field_1065)));
        if (!this.getCableType().canKill) {
            info.add((class_2561)new class_2588("techreborn.tooltip.cable.can_cover").method_27692(class_124.field_1080));
        }
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return new class_1799((class_1935)this.getCableType().block);
    }

    void appendTargets(List<OfferedEnergyStorage> targetStorages) {
        class_3218 serverWorld = (class_3218)this.field_11863;
        if (this.targets == null) {
            class_2680 newBlockState = this.method_11010();
            this.targets = new ArrayList<CableTarget>();
            for (class_2350 direction : class_2350.values()) {
                CableBlockEntity adjCable;
                boolean foundSomething = false;
                class_2338 adjPos = this.method_11016().method_10093(direction);
                class_2586 adjBe = serverWorld.method_8321(adjPos);
                class_2586 class_25862 = adjBe;
                if (class_25862 instanceof CableBlockEntity && (adjCable = (CableBlockEntity)class_25862).getCableType() == this.getCableType()) {
                    foundSomething = true;
                } else if (EnergyStorage.SIDED.find((class_1937)serverWorld, adjPos, null, adjBe, (Object)direction.method_10153()) != null) {
                    foundSomething = true;
                    this.targets.add(new CableTarget(direction, (BlockApiCache<EnergyStorage, class_2350>)BlockApiCache.create((BlockApiLookup)EnergyStorage.SIDED, (class_3218)serverWorld, (class_2338)adjPos)));
                }
                newBlockState = (class_2680)newBlockState.method_11657((class_2769)CableBlock.PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf(foundSomething));
            }
            serverWorld.method_8501(this.method_11016(), newBlockState);
        }
        for (CableTarget target : this.targets) {
            EnergyStorage storage = target.find();
            if (storage == null) {
                this.targets = null;
                continue;
            }
            targetStorages.add(new OfferedEnergyStorage(this, target.directionTo, storage));
        }
        this.blockedSides = 0;
    }

    private static final class CableTarget {
        private final class_2350 directionTo;
        private final BlockApiCache<EnergyStorage, class_2350> cache;

        CableTarget(class_2350 directionTo, BlockApiCache<EnergyStorage, class_2350> cache) {
            this.directionTo = directionTo;
            this.cache = cache;
        }

        @Nullable
        EnergyStorage find() {
            return (EnergyStorage)this.cache.find((Object)this.directionTo.method_10153());
        }
    }
}

