/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.generator;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.ItemFluidInfo;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.FluidGeneratorRecipeList;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.utils.FluidUtils;

public abstract class BaseFluidGeneratorBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider {
    private final FluidGeneratorRecipeList recipes;
    private final int euTick;
    private FluidGeneratorRecipe currentRecipe;
    private int ticksSinceLastChange;
    public final Tank tank;
    public final RebornInventory<?> inventory;
    protected long lastOutput = 0L;
    double pendingWithdraw = 0.0;

    public BaseFluidGeneratorBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state, EFluidGenerator type, String blockEntityName, FluidValue tankCapacity, int euTick) {
        super(blockEntityType, pos, state);
        this.recipes = GeneratorRecipeHelper.getFluidRecipesForGenerator(type);
        Validate.notNull((Object)this.recipes, (String)("null recipe list for " + type.getRecipeID()), (Object[])new Object[0]);
        this.tank = new Tank(blockEntityName, tankCapacity, (MachineBaseBlockEntity)this);
        this.inventory = new RebornInventory(3, blockEntityName, 64, (MachineBaseBlockEntity)this);
        this.euTick = euTick;
        this.ticksSinceLastChange = 0;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (world.field_9236) {
            return;
        }
        if (this.ticksSinceLastChange >= 10) {
            class_1799 inputStack = this.inventory.method_5438(0);
            if (!inputStack.method_7960()) {
                if (FluidUtils.isContainerEmpty(inputStack) && !this.tank.getFluidAmount().isEmpty()) {
                    FluidUtils.fillContainers(this.tank, this.inventory, 0, 1);
                } else if (inputStack.method_7909() instanceof ItemFluidInfo && this.getRecipes().getRecipeForFluid(((ItemFluidInfo)inputStack.method_7909()).getFluid(inputStack)).isPresent()) {
                    FluidUtils.drainContainers(this.tank, this.inventory, 0, 1);
                }
            }
            this.ticksSinceLastChange = 0;
        }
        if (!this.tank.getFluidAmount().isEmpty()) {
            if (this.currentRecipe == null || !FluidUtils.fluidEquals(this.currentRecipe.fluid(), this.tank.getFluid())) {
                this.currentRecipe = this.getRecipes().getRecipeForFluid(this.tank.getFluid()).orElse(null);
            }
            if (this.currentRecipe != null) {
                int euPerBucket = this.currentRecipe.getEnergyPerBucket();
                float fluidPerTick = (float)this.euTick / ((float)euPerBucket / (float)FluidValue.BUCKET.getRawValue());
                if (this.tryAddingEnergy(this.euTick)) {
                    this.pendingWithdraw += (double)fluidPerTick;
                    int currentWithdraw = (int)this.pendingWithdraw;
                    this.pendingWithdraw -= (double)currentWithdraw;
                    this.tank.getFluidInstance().subtractAmount(FluidValue.fromRaw((long)currentWithdraw));
                    this.lastOutput = world.method_8510();
                }
            }
        }
        if (world.method_8510() - this.lastOutput < 30L && !this.isActive()) {
            world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
        } else if (world.method_8510() - this.lastOutput > 30L && this.isActive()) {
            world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public int getProgressScaled(int scale) {
        if (this.isActive()) {
            return this.ticksSinceLastChange * scale;
        }
        return 0;
    }

    protected boolean tryAddingEnergy(int amount) {
        if (this.getFreeSpace() > 0L) {
            this.addEnergy(amount);
            return true;
        }
        return false;
    }

    public FluidGeneratorRecipeList getRecipes() {
        return this.recipes;
    }

    public long getBaseMaxOutput() {
        return this.euTick;
    }

    public long getBaseMaxInput() {
        return 0L;
    }

    public boolean canAcceptEnergy(@Nullable class_2350 side) {
        return false;
    }

    public RebornInventory<?> getInventory() {
        return this.inventory;
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.tank.read(tagCompound);
    }

    public class_2487 method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        this.tank.write(tagCompound);
        return tagCompound;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public int getTicksSinceLastChange() {
        return this.ticksSinceLastChange;
    }

    public void setTicksSinceLastChange(int ticksSinceLastChange) {
        this.ticksSinceLastChange = ticksSinceLastChange;
    }

    public FluidValue getTankAmount() {
        return this.tank.getFluidAmount();
    }

    public void setTankAmount(FluidValue amount) {
        this.tank.setFluidAmount(amount);
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

