/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.iron;

import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import reborncore.client.screen.BuiltScreenHandlerProvider;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.RebornInventory;
import techreborn.blockentity.machine.iron.AbstractIronMachineBlockEntity;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;
import techreborn.utils.RecipeUtils;

public class IronFurnaceBlockEntity
extends AbstractIronMachineBlockEntity
implements BuiltScreenHandlerProvider {
    int inputSlot = 0;
    int outputSlot = 1;
    public float experience;
    private class_1860<?> lastRecipe = null;

    public IronFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.IRON_FURNACE, pos, state, 2, TRContent.Machine.IRON_FURNACE.block);
        this.inventory = new RebornInventory(3, "IronFurnaceBlockEntity", 64, (MachineBaseBlockEntity)this);
    }

    public void handleGuiInputFromClient(class_1657 playerIn) {
        class_1657 class_16572 = playerIn;
        if (class_16572 instanceof class_3222) {
            int expToDrop;
            class_3222 player = (class_3222)class_16572;
            for (int totalExperience = (int)this.experience; totalExperience > 0; totalExperience -= expToDrop) {
                expToDrop = class_1303.method_5918((int)totalExperience);
                player.field_6002.method_8649((class_1297)new class_1303(player.field_6002, player.method_23317(), player.method_23318() + 0.5, player.method_23321() + 0.5, expToDrop));
            }
        }
        this.experience = 0.0f;
    }

    private class_1799 getResultFor(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (this.lastRecipe != null && RecipeUtils.matchesSingleInput(this.lastRecipe, stack)) {
            return this.lastRecipe.method_8110();
        }
        class_1860 matchingRecipe = RecipeUtils.getMatchingRecipe(this.field_11863, class_3956.field_17546, stack).orElse(null);
        if (matchingRecipe != null) {
            this.lastRecipe = matchingRecipe;
            return matchingRecipe.method_8110().method_7972();
        }
        return class_1799.field_8037;
    }

    private float getExperienceFor(class_1799 stack) {
        Optional recipe = this.field_11863.method_8433().method_8132(class_3956.field_17546, (class_1263)this, this.field_11863);
        return recipe.map(class_1874::method_8171).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    protected void smelt() {
        if (!this.canSmelt()) {
            return;
        }
        class_1799 inputStack = this.inventory.method_5438(this.inputSlot);
        class_1799 resultStack = this.getResultFor(inputStack);
        if (this.inventory.method_5438(this.outputSlot).method_7960()) {
            this.inventory.method_5447(this.outputSlot, resultStack.method_7972());
        } else if (this.inventory.method_5438(this.outputSlot).method_7962(resultStack)) {
            this.inventory.method_5438(this.outputSlot).method_7933(resultStack.method_7947());
        }
        this.experience += this.getExperienceFor(inputStack);
        if (inputStack.method_7947() > 1) {
            this.inventory.shrinkSlot(this.inputSlot, 1);
        } else {
            this.inventory.method_5447(this.inputSlot, class_1799.field_8037);
        }
    }

    @Override
    protected boolean canSmelt() {
        class_1799 inputStack = this.inventory.method_5438(this.inputSlot);
        if (inputStack.method_7960()) {
            return false;
        }
        class_1799 outputStack = this.getResultFor(inputStack);
        if (outputStack.method_7960()) {
            return false;
        }
        class_1799 outputSlotStack = this.inventory.method_5438(this.outputSlot);
        if (outputSlotStack.method_7960()) {
            return true;
        }
        if (!outputSlotStack.method_7962(outputStack)) {
            return false;
        }
        int result = outputSlotStack.method_7947() + outputStack.method_7947();
        return result <= this.inventory.getStackLimit() && result <= outputStack.method_7914();
    }

    public boolean isStackValid(int slotID, class_1799 stack) {
        return !this.getResultFor(stack).method_7960();
    }

    @Override
    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.experience = compoundTag.method_10583("Experience");
    }

    @Override
    public class_2487 method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10548("Experience", this.experience);
        return compoundTag;
    }

    public float getExperience() {
        return this.experience;
    }

    public void setExperience(float experience) {
        this.experience = experience;
    }

    public int[] getInputSlots() {
        return new int[]{this.inputSlot};
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("ironfurnace").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).fuelSlot(2, 56, 53).slot(0, 56, 17).outputSlot(1, 116, 35).sync(this::getBurnTime, this::setBurnTime).sync(this::getProgress, this::setProgress).sync(this::getTotalBurnTime, this::setTotalBurnTime).sync(this::getExperience, this::setExperience).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

