/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.multiblock;

import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;
import reborncore.client.screen.BuiltScreenHandlerProvider;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.client.screen.builder.Syncable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.fluid.FluidValue;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.IInventoryAccess;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.blockentity.machine.GenericMachineBlockEntity;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;
import techreborn.utils.FluidUtils;

public class FluidReplicatorBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider {
    public static final FluidValue TANK_CAPACITY = FluidValue.BUCKET.multiply(16L);
    public Tank tank;
    int ticksSinceLastChange;

    public FluidReplicatorBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.FLUID_REPLICATOR, pos, state, "FluidReplicator", TechRebornConfig.fluidReplicatorMaxInput, TechRebornConfig.fluidReplicatorMaxEnergy, TRContent.Machine.FLUID_REPLICATOR.block, 3);
        this.inventory = new RebornInventory(4, "FluidReplicatorBlockEntity", 64, (MachineBaseBlockEntity)this, FluidReplicatorBlockEntity.getInventoryAccess());
        this.crafter = new RecipeCrafter(ModRecipes.FLUID_REPLICATOR, (class_2586)this, 1, 0, this.inventory, new int[]{0}, null);
        this.tank = new Tank("FluidReplicatorBlockEntity", TANK_CAPACITY, (MachineBaseBlockEntity)this);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2680 state = TRContent.MachineBlocks.ADVANCED.getCasing().method_9564();
        writer.translate(1, 0, -1).ring(class_2350.class_2351.field_11052, 3, 0, 3, (v, p) -> v.method_8320(p) == state, state, null, null);
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        if (world == null) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (!world.field_9236 && this.ticksSinceLastChange >= 10) {
            if (!this.inventory.method_5438(1).method_7960()) {
                FluidUtils.fillContainers(this.tank, (class_1263)this.inventory, 1, 2);
                if (this.tank.isEmpty()) {
                    this.tank.setFluid(class_3612.field_15906);
                }
            }
            this.ticksSinceLastChange = 0;
        }
        super.tick(world, pos, state, blockEntity);
    }

    @Override
    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.tank.read(tagCompound);
    }

    public class_2487 method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        this.tank.write(tagCompound);
        return tagCompound;
    }

    private static IInventoryAccess<FluidReplicatorBlockEntity> getInventoryAccess() {
        return (slotID, stack, face, direction, blockEntity) -> {
            if (slotID == 0) {
                return stack.method_7962(TRContent.Parts.UU_MATTER.getStack());
            }
            return true;
        };
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("fluidreplicator").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).fluidSlot(1, 124, 35).filterSlot(0, 55, 45, stack -> stack.method_7962(TRContent.Parts.UU_MATTER.getStack())).outputSlot(2, 124, 55).energySlot(3, 8, 72).sync((Syncable)this.tank).syncEnergyValue().syncCrafterValue().addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

