/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init.template;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2378;

public class TemplateProcessor {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path resources;

    public TemplateProcessor(Path resources) {
        this.resources = resources;
    }

    public void processSimpleBlocks(String template, List<class_2248> blocks) throws IOException {
        for (class_2248 block : blocks) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("name", class_2378.field_11146.method_10221((Object)block).method_12832());
            this.process(template, values);
        }
    }

    public void process(String template, Map<String, String> values) throws IOException {
        Path directory = this.resources.resolve("templates").resolve(template);
        JsonObject info = this.getJson(directory.resolve("info.json"));
        JsonArray files = info.getAsJsonArray("files");
        for (JsonElement fileElement : files) {
            JsonObject file = fileElement.getAsJsonObject();
            Path inputFile = directory.resolve(file.get("from").getAsString());
            Path outputFile = this.resources.resolve(TemplateProcessor.replaceValues(file.get("to").getAsString(), values));
            this.processFile(inputFile, outputFile, values);
        }
    }

    private void processFile(Path inputFile, Path outputFile, Map<String, String> values) throws IOException {
        String input = Files.readString(inputFile);
        String output = TemplateProcessor.replaceValues(input, values);
        Files.writeString(outputFile, (CharSequence)output, new OpenOption[0]);
    }

    private static String replaceValues(String input, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            input = input.replaceAll("%" + entry.getKey() + "%", entry.getValue());
        }
        return input;
    }

    private JsonObject getJson(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Failed to find " + path.toString());
        }
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
            return jsonObject;
        }
    }
}

