/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_5134;
import reborncore.api.items.ArmorBlockEntityTicker;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.api.items.ItemStackModifiers;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.ItemUtils;
import techreborn.TechReborn;
import techreborn.config.TechRebornConfig;
import techreborn.items.armor.TRArmourItem;
import techreborn.utils.InitUtils;

public class QuantumSuitItem
extends TRArmourItem
implements ItemStackModifiers,
ArmorBlockEntityTicker,
ArmorRemoveHandler,
RcEnergyItem {
    public final long flyCost = TechRebornConfig.quantumSuitFlyingCost;
    public final long swimCost = TechRebornConfig.quantumSuitSwimmingCost;
    public final long breathingCost = TechRebornConfig.quantumSuitBreathingCost;
    public final long sprintingCost = TechRebornConfig.quantumSuitSprintingCost;
    public final long fireExtinguishCost = TechRebornConfig.fireExtinguishCost;
    public final boolean enableSprint = TechRebornConfig.quantumSuitEnableSprint;
    public final boolean enableFlight = TechRebornConfig.quantumSuitEnableFlight;

    public QuantumSuitItem(class_1741 material, class_1304 slot) {
        super(material, slot, new class_1792.class_1793().method_7892(TechReborn.ITEMGROUP).method_7895(-1).method_7889(1));
    }

    public void getAttributeModifiers(class_1304 equipmentSlot, class_1799 stack, Multimap<class_1320, class_1322> attributes) {
        attributes.removeAll((Object)class_5134.field_23719);
        if (this.field_7880 == class_1304.field_6172 && equipmentSlot == class_1304.field_6172 && this.enableSprint && this.getStoredEnergy(stack) > this.sprintingCost) {
            attributes.put((Object)class_5134.field_23719, (Object)new class_1322(MODIFIERS[equipmentSlot.method_5927()], "Movement Speed", 0.15, class_1322.class_1323.field_6328));
        }
        if (equipmentSlot == this.field_7880 && this.getStoredEnergy(stack) > 0L) {
            attributes.put((Object)class_5134.field_23724, (Object)new class_1322(MODIFIERS[this.field_7880.method_5927()], "Armor modifier", 20.0, class_1322.class_1323.field_6328));
            attributes.put((Object)class_5134.field_23718, (Object)new class_1322(MODIFIERS[this.field_7880.method_5927()], "Knockback modifier", 2.0, class_1322.class_1323.field_6328));
        }
    }

    public void tickArmor(class_1799 stack, class_1657 playerEntity) {
        switch (this.field_7880) {
            case field_6169: {
                if (!playerEntity.method_5869() || !this.tryUseEnergy(stack, this.breathingCost)) break;
                playerEntity.method_6092(new class_1293(class_1294.field_5923, 5, 1));
                break;
            }
            case field_6174: {
                if (this.enableFlight) {
                    if (this.getStoredEnergy(stack) > this.flyCost && !TechReborn.elytraPredicate.test(playerEntity)) {
                        playerEntity.method_31549().field_7478 = true;
                        if (playerEntity.method_31549().field_7479) {
                            this.tryUseEnergy(stack, this.flyCost);
                        }
                        playerEntity.method_24830(true);
                    } else {
                        playerEntity.method_31549().field_7478 = false;
                        playerEntity.method_31549().field_7479 = false;
                    }
                }
                if (!playerEntity.method_5809() || this.getStoredEnergy(stack) <= this.fireExtinguishCost) break;
                playerEntity.method_5646();
                break;
            }
            case field_6172: {
                if (!playerEntity.method_5624() || !this.enableSprint) break;
                this.tryUseEnergy(stack, this.sprintingCost);
                break;
            }
            case field_6166: {
                if (!playerEntity.method_5681() || !this.tryUseEnergy(stack, this.swimCost)) break;
                playerEntity.method_6092(new class_1293(class_1294.field_5900, 5, 1));
                break;
            }
        }
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return HashMultimap.create();
    }

    public void onRemoved(class_1657 playerEntity) {
        if (this.field_7880 == class_1304.field_6174 && this.enableFlight && !playerEntity.method_7337() && !playerEntity.method_7325()) {
            playerEntity.method_31549().field_7478 = false;
            playerEntity.method_31549().field_7479 = false;
        }
    }

    public double getDurability(class_1799 stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((class_1799)stack);
    }

    public boolean showDurability(class_1799 stack) {
        return true;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int getDurabilityColor(class_1799 stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    public boolean method_7878(class_1799 itemStack_1, class_1799 itemStack_2) {
        return false;
    }

    public long getEnergyCapacity() {
        return TechRebornConfig.quantumSuitCapacity;
    }

    public RcEnergyTier getTier() {
        return RcEnergyTier.EXTREME;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7850(class_1761 group, class_2371<class_1799> itemList) {
        if (!this.method_7877(group)) {
            return;
        }
        InitUtils.initPoweredItems((class_1792)this, itemList);
    }
}

