/*
 * Decompiled with CFR 0.152.
 */
package techreborn.utils;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.fluid.container.ItemFluidInfo;
import reborncore.common.util.Tank;
import reborncore.mixin.common.AccessorFluidBlock;

public class FluidUtils {
    @NotNull
    public static class_3611 fluidFromBlock(class_2248 block) {
        if (block instanceof AccessorFluidBlock) {
            return ((AccessorFluidBlock)block).getFluid();
        }
        return class_3612.field_15906;
    }

    public static List<class_3611> getAllFluids() {
        return class_2378.field_11154.method_10220().collect(Collectors.toList());
    }

    public static boolean drainContainers(Tank tank, class_1263 inventory, int inputSlot, int outputSlot) {
        return FluidUtils.drainContainers(tank, inventory, inputSlot, outputSlot, false);
    }

    public static boolean drainContainers(Tank tank, class_1263 inventory, int inputSlot, int outputSlot, boolean voidFluid) {
        FluidValue freeSpace;
        class_1799 inputStack = inventory.method_5438(inputSlot);
        class_1799 outputStack = inventory.method_5438(outputSlot);
        if (inputStack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = inputStack.method_7909();
        if (!(class_17922 instanceof ItemFluidInfo)) {
            return false;
        }
        ItemFluidInfo itemFluidInfo = (ItemFluidInfo)class_17922;
        if (FluidUtils.isContainerEmpty(inputStack)) {
            return false;
        }
        if (outputStack.method_7947() >= outputStack.method_7914()) {
            return false;
        }
        if (!outputStack.method_7960() && !FluidUtils.isContainerEmpty(outputStack)) {
            return false;
        }
        if (!outputStack.method_7960() && !outputStack.method_7929(itemFluidInfo.getEmpty())) {
            return false;
        }
        FluidInstance tankFluidInstance = tank.getFluidInstance();
        class_3611 tankFluid = tankFluidInstance.getFluid();
        if ((tankFluidInstance.isEmpty() || tankFluid == itemFluidInfo.getFluid(inputStack)) && ((freeSpace = tank.getFluidValueCapacity().subtract(tankFluidInstance.getAmount())).equalOrMoreThan(FluidValue.BUCKET) || voidFluid)) {
            inputStack.method_7934(1);
            if (!voidFluid) {
                tankFluidInstance.setFluid(itemFluidInfo.getFluid(inputStack));
                tankFluidInstance.addAmount(FluidValue.BUCKET);
            }
            if (outputStack.method_7960()) {
                inventory.method_5447(outputSlot, itemFluidInfo.getEmpty());
            } else {
                outputStack.method_7933(1);
            }
        }
        return true;
    }

    public static boolean fillContainers(Tank source, class_1263 inventory, int inputSlot, int outputSlot) {
        class_1799 inputStack = inventory.method_5438(inputSlot);
        class_1799 outputStack = inventory.method_5438(outputSlot);
        if (!FluidUtils.isContainerEmpty(inputStack)) {
            return false;
        }
        ItemFluidInfo itemFluidInfo = (ItemFluidInfo)inputStack.method_7909();
        FluidInstance sourceFluid = source.getFluidInstance();
        if (sourceFluid.getFluid() == class_3612.field_15906 || sourceFluid.getAmount().lessThan(FluidValue.BUCKET)) {
            return false;
        }
        if (!outputStack.method_7960()) {
            if (outputStack.method_7947() >= outputStack.method_7914()) {
                return false;
            }
            class_1792 class_17922 = outputStack.method_7909();
            if (!(class_17922 instanceof ItemFluidInfo)) {
                return false;
            }
            ItemFluidInfo outputFluidInfo = (ItemFluidInfo)class_17922;
            if (!outputStack.method_7929(itemFluidInfo.getEmpty())) {
                return false;
            }
            if (outputFluidInfo.getFluid(outputStack) != sourceFluid.getFluid()) {
                return false;
            }
        }
        if (outputStack.method_7960()) {
            inventory.method_5447(outputSlot, itemFluidInfo.getFull(sourceFluid.getFluid()));
        } else {
            outputStack.method_7933(1);
        }
        sourceFluid.subtractAmount(FluidValue.BUCKET);
        inputStack.method_7934(1);
        return true;
    }

    public static boolean fluidEquals(@NotNull class_3611 fluid, @NotNull class_3611 fluid1) {
        return fluid == fluid1;
    }

    public static boolean isContainerEmpty(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ItemFluidInfo) {
            ItemFluidInfo itemFluidInfo = (ItemFluidInfo)class_17922;
            return itemFluidInfo.getFluid(stack) == class_3612.field_15906;
        }
        return false;
    }
}

