/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.generator;

import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.class_3611;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.FluidGeneratorRecipeList;

public class GeneratorRecipeHelper {
    public static EnumMap<EFluidGenerator, FluidGeneratorRecipeList> fluidRecipes = new EnumMap(EFluidGenerator.class);

    public static void registerFluidRecipe(EFluidGenerator generatorType, class_3611 fluidType, int energyPerMb) {
        fluidRecipes.putIfAbsent(generatorType, new FluidGeneratorRecipeList(new FluidGeneratorRecipe[0]));
        fluidRecipes.get((Object)generatorType).addRecipe(new FluidGeneratorRecipe(fluidType, energyPerMb, generatorType));
    }

    public static FluidGeneratorRecipeList getFluidRecipesForGenerator(EFluidGenerator generatorType) {
        return fluidRecipes.get((Object)generatorType);
    }

    public static void removeFluidRecipe(EFluidGenerator generatorType, class_3611 fluidType) {
        FluidGeneratorRecipeList recipeList = GeneratorRecipeHelper.getFluidRecipesForGenerator(generatorType);
        Optional<FluidGeneratorRecipe> recipe = recipeList.getRecipeForFluid(fluidType);
        if (recipe.isPresent()) {
            recipeList.removeRecipe(recipe.get());
        }
    }
}

