/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.cable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3000;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.common.network.ClientBoundPackets;
import reborncore.common.network.NetworkManager;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergySide;
import team.reborn.energy.EnergyStorage;
import team.reborn.energy.EnergyTier;
import techreborn.blocks.cable.CableBlock;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class CableBlockEntity
extends class_2586
implements class_3000,
IListInfoProvider,
IToolDrop,
EnergyStorage {
    private double energy = 0.0;
    private TRContent.Cables cableType = null;
    private ArrayList<class_2350> sendingFace = new ArrayList();
    private class_2680 cover = null;

    public CableBlockEntity() {
        super(TRBlockEntities.CABLE);
    }

    public CableBlockEntity(TRContent.Cables type) {
        super(TRBlockEntities.CABLE);
        this.cableType = type;
    }

    private TRContent.Cables getCableType() {
        if (this.cableType != null) {
            return this.cableType;
        }
        if (this.field_11863 == null) {
            return TRContent.Cables.COPPER;
        }
        class_2248 block = this.field_11863.method_8320(this.field_11867).method_26204();
        if (block instanceof CableBlock) {
            return ((CableBlock)block).type;
        }
        return TRContent.Cables.COPPER;
    }

    public class_2487 method_16887() {
        return this.method_11007(new class_2487());
    }

    public class_2622 method_16886() {
        class_2487 nbtTag = new class_2487();
        this.method_11007(nbtTag);
        return new class_2622(this.method_11016(), 1, nbtTag);
    }

    public void method_11014(class_2680 blockState, class_2487 compound) {
        super.method_11014(blockState, compound);
        if (compound.method_10545("energy")) {
            this.energy = compound.method_10574("energy");
        }
        this.cover = compound.method_10545("cover") ? class_2512.method_10681((class_2487)compound.method_10562("cover")) : null;
    }

    public class_2487 method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10549("energy", this.energy);
        if (this.cover != null) {
            compound.method_10566("cover", (class_2520)class_2512.method_10686((class_2680)this.cover));
        }
        return compound;
    }

    public void method_16896() {
        if (this.field_11863.field_9236) {
            return;
        }
        this.sendingFace.clear();
        if (this.getEnergy() == 0.0) {
            return;
        }
        ArrayList<Pair> acceptors = new ArrayList<Pair>();
        ArrayList<CableBlockEntity> cables = new ArrayList<CableBlockEntity>();
        for (class_2350 face : class_2350.values()) {
            class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10093(face));
            if (blockEntity == null || !Energy.valid((Object)blockEntity)) continue;
            if (blockEntity instanceof CableBlockEntity) {
                CableBlockEntity cableBlockEntity2 = (CableBlockEntity)blockEntity;
                if (cableBlockEntity2.getTier() == this.getTier()) {
                    if (!(cableBlockEntity2.getEnergy() < this.getEnergy())) continue;
                    cables.add(cableBlockEntity2);
                    continue;
                }
                if (this.energy <= Energy.of((Object)blockEntity).side(face).getEnergy()) continue;
            }
            if (!(Energy.of((Object)blockEntity).side(face.method_10153()).getMaxInput() > 0.0)) continue;
            acceptors.add(Pair.of((Object)blockEntity, (Object)face));
            if (this.sendingFace.contains(face)) continue;
            this.sendingFace.add(face);
        }
        if (!acceptors.isEmpty()) {
            Collections.shuffle(acceptors);
            acceptors.forEach(pair -> Energy.of((Object)((Object)this)).into(Energy.of((Object)pair.getLeft()).side(((class_2350)pair.getRight()).method_10153())).move());
        }
        if (!cables.isEmpty()) {
            cables.add(this);
            double energyTotal = cables.stream().mapToDouble(CableBlockEntity::getEnergy).sum();
            double energyPer = energyTotal / (double)cables.size();
            cables.forEach(cableBlockEntity -> cableBlockEntity.setEnergy(energyPer));
        }
    }

    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        info.add((class_2561)new class_2588("techreborn.tooltip.transferRate").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocaliszedPowerFormatted((int)this.getCableType().transferRate)).method_27692(class_124.field_1065).method_27693("/t"));
        info.add((class_2561)new class_2588("techreborn.tooltip.tier").method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)new class_2585(StringUtils.toFirstCapitalAllLowercase((String)this.getCableType().tier.toString())).method_27692(class_124.field_1065)));
        if (!this.getCableType().canKill) {
            info.add((class_2561)new class_2588("techreborn.tooltip.cable.can_cover").method_27692(class_124.field_1080));
        }
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return new class_1799((class_1935)this.getCableType().block);
    }

    public double getEnergy() {
        return this.getStored(EnergySide.UNKNOWN);
    }

    public void setEnergy(double energy) {
        this.setStored(energy);
    }

    public double useEnergy(double energyOut, boolean simulate) {
        if (energyOut > this.energy) {
            energyOut = this.energy;
        }
        if (!simulate) {
            this.setEnergy(this.energy - energyOut);
        }
        return energyOut;
    }

    public double addEnergy(double energyIn) {
        if (this.isFull()) {
            return energyIn;
        }
        double maxStore = this.getMaxStoredPower();
        if (energyIn + this.energy <= maxStore) {
            this.setEnergy(energyIn + this.energy);
            return 0.0;
        }
        double amountCanAdd = maxStore - this.energy;
        this.setEnergy(amountCanAdd + this.energy);
        return energyIn - amountCanAdd;
    }

    public boolean canAcceptEnergy(EnergySide direction) {
        if (this.sendingFace.contains(direction)) {
            return false;
        }
        return this.getMaxStoredPower() != this.getEnergy();
    }

    public boolean isFull() {
        return this.getMaxStoredPower() == this.getEnergy();
    }

    public double getMaxInput(EnergySide side) {
        if (!this.canAcceptEnergy(side)) {
            return 0.0;
        }
        return this.getCableType().transferRate;
    }

    public double getMaxOutput(EnergySide side) {
        return this.getCableType().transferRate;
    }

    public double getMaxStoredPower() {
        return this.getCableType().transferRate * 4;
    }

    public EnergyTier getTier() {
        return PowerAcceptorBlockEntity.getTier((int)this.getCableType().transferRate);
    }

    public double getStored(EnergySide face) {
        return this.energy;
    }

    public void setStored(double amount) {
        this.energy = amount;
    }

    public class_2680 getCover() {
        return this.cover;
    }

    public void setCover(class_2680 cover) {
        this.cover = cover;
        if (!this.field_11863.field_9236) {
            NetworkManager.sendToTracking((class_2596)ClientBoundPackets.createCustomDescriptionPacket((class_2586)this), (class_2586)this);
        }
    }
}

